require 'rails_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

RSpec.describe DiagnosisModifiersController, :type => :controller do

  # This should return the minimal set of attributes required to create a valid
  # DiagnosisModifier. As you add validations to DiagnosisModifier, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) {
    skip("Add a hash of attributes valid for your model")
  }

  let(:invalid_attributes) {
    skip("Add a hash of attributes invalid for your model")
  }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # DiagnosisModifiersController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all diagnosis_modifiers as @diagnosis_modifiers", cui: true do
      diagnosis_modifier = DiagnosisModifier.create! valid_attributes
      get :index, {}, valid_session
      expect(assigns(:diagnosis_modifiers)).to eq([diagnosis_modifier])
    end
  end

  describe "GET show" do
    it "assigns the requested diagnosis_modifier as @diagnosis_modifier", cui: true do
      diagnosis_modifier = DiagnosisModifier.create! valid_attributes
      get :show, {:id => diagnosis_modifier.to_param}, valid_session
      expect(assigns(:diagnosis_modifier)).to eq(diagnosis_modifier)
    end
  end

  describe "GET new" do
    it "assigns a new diagnosis_modifier as @diagnosis_modifier", cui: true do
      get :new, {}, valid_session
      expect(assigns(:diagnosis_modifier)).to be_a_new(DiagnosisModifier)
    end
  end

  describe "GET edit" do
    it "assigns the requested diagnosis_modifier as @diagnosis_modifier", cui: true do
      diagnosis_modifier = DiagnosisModifier.create! valid_attributes
      get :edit, {:id => diagnosis_modifier.to_param}, valid_session
      expect(assigns(:diagnosis_modifier)).to eq(diagnosis_modifier)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new DiagnosisModifier", cui: true do
        expect {
          post :create, {:diagnosis_modifier => valid_attributes}, valid_session
        }.to change(DiagnosisModifier, :count).by(1)
      end

      it "assigns a newly created diagnosis_modifier as @diagnosis_modifier", cui: true do
        post :create, {:diagnosis_modifier => valid_attributes}, valid_session
        expect(assigns(:diagnosis_modifier)).to be_a(DiagnosisModifier)
        expect(assigns(:diagnosis_modifier)).to be_persisted
      end

      it "redirects to the created diagnosis_modifier", cui: true do
        post :create, {:diagnosis_modifier => valid_attributes}, valid_session
        expect(response).to redirect_to(DiagnosisModifier.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved diagnosis_modifier as @diagnosis_modifier", cui: true do
        post :create, {:diagnosis_modifier => invalid_attributes}, valid_session
        expect(assigns(:diagnosis_modifier)).to be_a_new(DiagnosisModifier)
      end

      it "re-renders the 'new' template", cui: true do
        post :create, {:diagnosis_modifier => invalid_attributes}, valid_session
        expect(response).to render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      let(:new_attributes) {
        skip("Add a hash of attributes valid for your model")
      }

      it "updates the requested diagnosis_modifier", cui: true do
        diagnosis_modifier = DiagnosisModifier.create! valid_attributes
        put :update, {:id => diagnosis_modifier.to_param, :diagnosis_modifier => new_attributes}, valid_session
        diagnosis_modifier.reload
        skip("Add assertions for updated state")
      end

      it "assigns the requested diagnosis_modifier as @diagnosis_modifier", cui: true do
        diagnosis_modifier = DiagnosisModifier.create! valid_attributes
        put :update, {:id => diagnosis_modifier.to_param, :diagnosis_modifier => valid_attributes}, valid_session
        expect(assigns(:diagnosis_modifier)).to eq(diagnosis_modifier)
      end

      it "redirects to the diagnosis_modifier", cui: true do
        diagnosis_modifier = DiagnosisModifier.create! valid_attributes
        put :update, {:id => diagnosis_modifier.to_param, :diagnosis_modifier => valid_attributes}, valid_session
        expect(response).to redirect_to(diagnosis_modifier)
      end
    end

    describe "with invalid params" do
      it "assigns the diagnosis_modifier as @diagnosis_modifier", cui: true do
        diagnosis_modifier = DiagnosisModifier.create! valid_attributes
        put :update, {:id => diagnosis_modifier.to_param, :diagnosis_modifier => invalid_attributes}, valid_session
        expect(assigns(:diagnosis_modifier)).to eq(diagnosis_modifier)
      end

      it "re-renders the 'edit' template", cui: true do
        diagnosis_modifier = DiagnosisModifier.create! valid_attributes
        put :update, {:id => diagnosis_modifier.to_param, :diagnosis_modifier => invalid_attributes}, valid_session
        expect(response).to render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested diagnosis_modifier" do
      diagnosis_modifier = DiagnosisModifier.create! valid_attributes
      expect {
        delete :destroy, {:id => diagnosis_modifier.to_param}, valid_session
      }.to change(DiagnosisModifier, :count).by(-1)
    end

    it "redirects to the diagnosis_modifiers list" do
      diagnosis_modifier = DiagnosisModifier.create! valid_attributes
      delete :destroy, {:id => diagnosis_modifier.to_param}, valid_session
      expect(response).to redirect_to(diagnosis_modifiers_url)
    end
  end

end
