require File.expand_path('../spec_helper', __FILE__)

describe Report do
  let(:params)  {
                  {
                    environment:      'development',
                    target_folder:    'tmp/led/cui_users_lists',
                    report_base_name: 'cui_users_list_report',
                    current_script:   'cui_users_lists',
                    pid:              1776
                  }
                }

  describe 'initialize (Report.new(params))' do
    describe 'Params' do
      subject { params }

      describe 'Keys . . .' do
        it 'key: environment' do
          expect(subject).to have_key(:environment)
        end

        it 'key: target_folder' do
          expect(subject).to have_key(:target_folder)
        end

        it 'key: report_base_name' do
          expect(subject).to have_key(:report_base_name)
        end

        it 'key: current_script' do
          expect(subject).to have_key(:current_script)
        end

        it 'key: pid' do
          expect(subject).to have_key(:pid)
        end
      end

      describe 'expected types' do
        it 'Params is a hash' do
          expect(subject.is_a?(Hash)).to be_truthy
        end

        describe 'param values' do
          it 'environment is a string' do
            expect(subject[:environment]).to be_a(String)
          end

          it 'target_folder is a string' do
            expect(subject[:target_folder]).to be_a(String)
          end

          it 'report_base_name is a string' do
            expect(subject[:report_base_name]).to be_a(String)
          end

          it 'current_script is a string' do
            expect(subject[:current_script]).to be_a(String)
          end

          it 'pid is an integer' do
            expect(subject[:pid]).to be_a(Integer)
          end
        end
      end
    end

    describe 'Report Object has expected values' do
      subject { Report.new(params) }

      it "environment value is correct" do
        expect(subject.instance_variable_get(:@environment)).to \
          eql('development')
      end

      it "target_folder value is correct" do
        expect(subject.instance_variable_get(:@target_folder)).to \
          eql('tmp/led/cui_users_lists')
      end

      it "pid value is correct" do
        expect(subject.instance_variable_get(:@pid)).to eql(1776)
      end

      it "current_script value is correct" do
        expect(subject.instance_variable_get(:@current_script)).to \
          eql('cui_users_lists')
      end

      it "report_base_name value is correct" do
        expect(subject.instance_variable_get(:@report_base_name)).to \
          eql('cui_users_list_report')
      end
    end
  end

  describe 'Methods' do
    subject { report = Report.new(params) }

    it 'responds to exposed metods' do
      expect(subject).to respond_to(:run)
    end

    it 'does not respnd to private methods' do
      expect(subject).not_to respond_to(:initialize)
      expect(subject).not_to respond_to(:generate_report)
      expect(subject).not_to respond_to(:file_name)
    end
  end
end
