# lib/tasks/puma.rake

namespace :puma do

  desc "Start the Puma application Server"
  task :start do
    system 'pumactl start'
  end


  desc "Stop the Puma application Server"
  task :stop do
    system 'pumactl stop'
  end


  desc "Restart the Puma application Server"
  task :restart do
    STDERR.puts "=== Starting Maintenance Mode ==="
    Rake::Task["puma:stop"].invoke

    wait_seconds = 5  # NOTE: will have to play with this magic number to see what value works best
    STDERR.print "Waiting for #{wait_seconds} seconds for puma to stop all workers ... "
    sleep(wait_seconds)
    STDERR.puts "done."

    Rake::Task["puma:start"].invoke

    wait_seconds = 5  # NOTE: will have to play with this magic number to see what value works best
    STDERR.print "Waiting for #{wait_seconds} seconds for puma to start all workers ... "
    sleep(wait_seconds)
    STDERR.puts "done."

    Rake::Task["maintenance:end"].invoke
    STDERR.puts "=== Maintenance Mode is Over ==="
  end

end # namespace :puma do