namespace :eval_con_man do

  desc "TODO"
  task seed: :environment do
    filename = File.join(Rails.root, 'db', 'ecm_seeds.rb')
    dbq_test_data = File.join(Rails.root, 'db', 'dbq_test_data_init.rb')
    load(filename) if File.exist?(filename)
    load(dbq_test_data) if File.exist?(dbq_test_data)
  end

  task load_html: :environment do
    # Associates the first Evaluation Template to
    # the generated HTML Repository
    @html_repository = EvaluationTemplate.first.load_html_repository
  end


  desc "TODO"
  task seed_dump: :environment do
    filename = File.join(Rails.root, 'db', 'ecm_seeds.rb')
    seed_file = File.new(filename, "w+")
    seed_file << 'DiagnosisModifier.destroy_all' + "\n"
    seed_file << 'Diagnosis.destroy_all' + "\n"
    seed_file << 'DmAssignment.destroy_all' + "\n"
    seed_file << 'QuestionModifier.destroy_all' + "\n"
    seed_file << 'GeneralQuestion.destroy_all' + "\n"
    seed_file << 'QmAssignment.destroy_all' + "\n"
    seed_file << 'Symptom.destroy_all' + "\n"
    seed_file << 'MinorSystem.destroy_all' + "\n"
    seed_file << 'MajorSystem.destroy_all' + "\n"
    seed_file << 'EvaluationTemplate.destroy_all' + "\n"
    #seed_file << 'VbmsRFactGroup.destroy_all' + "\n"

    GeneralQuestion.all.each do |e|
      seed_file << 'GeneralQuestion.find_or_create_by(
                                      name: "'+e.name.to_s+'",
                                      label: %Q['+e.label.to_s+'],
                                      diagnosis_modifier_id: "'+e.diagnosis_modifier_id.to_s+'",
                                      minor_system_id: "'+e.minor_system_id.to_s+'",
                                      position: "'+e.position.to_s+'",
                                      created_at: "'+e.created_at.to_s+'",
                                      updated_at: "'+e.updated_at.to_s+'")' + "\n"
    end

    QuestionModifier.all.each do |d|
      seed_file << 'qm = QuestionModifier.find_or_create_by(
                                            name: "'+d.name.to_s+'",
                                            label: %Q['+d.label.to_s+'],
                                            mod_type: "'+d.mod_type.to_s+'",
                                            html: "'+d.html.to_s+'",
                                            created_at: "'+d.created_at.to_s+'",
                                            updated_at: "'+d.updated_at.to_s+'")' + "\n"
      seed_file << '  qm.list_values = []' + "\n"
      d.list_values.each do |l|
        seed_file << '  qm.list_values << "' + l + '"' + "\n"
      end
      seed_file << '  qm.save' + "\n"
    end

    QmAssignment.all.each do |e|
      seed_file << 'QmAssignment.find_or_create_by(
                                    name: "'+e.name.to_s+'",
                                    label: %Q['+e.label.to_s+'],
                                    exam_response_fields: "'+e.exam_response_fields.to_s+'",
                                    general_question_id: "'+e.general_question_id.to_s+'",
                                    question_modifier_id: "'+e.question_modifier_id.to_s+'",
                                    negative_show: "'+e.negative_show.to_s+'",
                                    position: "'+e.position.to_s+'",
                                    created_at: "'+e.created_at.to_s+'",
                                    updated_at: "'+e.updated_at.to_s+'")' + "\n"
    end

    DiagnosisModifier.all.each do |d|
      seed_file << 'dm = DiagnosisModifier.find_or_create_by(
                                            name: "'+d.name.to_s+'",
                                            label: %Q['+d.label.to_s+'],
                                            mod_type: "'+d.mod_type.to_s+'")' + "\n"
      seed_file << '  dm.list_values = []' + "\n"
      d.list_values.each do |l|
        seed_file << '  dm.list_values << "' + l + '"' + "\n"
      end
      seed_file << '  dm.save' + "\n"
    end

    Diagnosis.all.each do |d|
      seed_file << 'Diagnosis.find_or_create_by(
                                name: "'+d.name.to_s+'",
                                label: %Q['+d.label.to_s+'],
                                code: "'+d.code.to_s+'",
                                position: "'+d.position.to_s+'")' + "\n"
    end

    Symptom.all.each do |s|
      seed_file << 'Symptom.find_or_create_by(
                              name: "'+s.name.to_s+'",
                              label: "'+s.label.to_s+'",
                              position: "'+s.position.to_s+'")' + "\n"
    end

    MinorSystem.all.each do |m|
      seed_file << 'MinorSystem.find_or_create_by(
                                  name: "'+m.name.to_s+'",
                                  label: "'+m.label.to_s+'",
                                  position: "'+m.position.to_s+'")' + "\n"
    end

    MajorSystem.all.each do |m|
      seed_file << 'MajorSystem.find_or_create_by(
                                  name: "'+m.name.to_s+'",
                                  label: "'+m.label.to_s+'",
                                  position: "'+m.position.to_s+'")' + "\n"
    end

    EvaluationTemplate.all.each do |e|
      seed_file << 'EvaluationTemplate.find_or_create_by(name: "'+e.name.to_s+'",
       label: "'+e.label.to_s+'")' + "\n"
    end


    #VbmsRFactGroup.all.each do |v|
    #    seed_file << 'VbmsRFactGroup.find_or_create_by(name: "'+v.name.to_s+'", namespace: "'+v.namespace.to_s+'", fact_block_tag_name: "'+v.fact_block_tag_name.to_s+'", diagnosis_tag_name: "'+v.diagnosis_tag_name.to_s+'", symptom_tag_name: "'+v.symptom_tag_name.to_s+'", document_title: "'+v.document_title.to_s+'", diagnosis_info: \''+v.diagnosis_info.to_s+'\', symptom_info: \''+v.symptom_info.to_s+'\')' + "\n"
    #end


    DiagnosisModifier.all.each do |dm|
      if dm.diagnoses.any?
        seed_file << 'dmod = DiagnosisModifier.find_by_name("'+dm.name.to_s+'")' + "\n"
        dm.diagnoses.each do |d|
          seed_file << '    diag = Diagnosis.find_by_name("'+d.name.to_s+'")' + "\n"
          dma = dm.get_dm_assignments(d)
          dma.each do |a|
            seed_file << '    dmod.diagnoses << diag' + "\n"
            seed_file << '    dmod.get_dm_assignments(diag).order(id: :ASC).last.update(name: "'+a.name.to_s+'", label: "'+a.label.to_s+'", exam_response_fields: "'+a.exam_response_fields.to_s+'") ' + "\n"
          end
        end
      end
    end

    Symptom.all.each do |s|
      if s.diagnoses.any?
        seed_file << 'sym = Symptom.find_by_name("'+s.name.to_s+'")' + "\n"
        s.diagnoses.each do |d|
          seed_file << '    diag = Diagnosis.find_by_name("'+d.name.to_s+'")' + "\n"
          seed_file << '    sym.diagnoses << diag' + "\n"
        end
      end
    end

    MinorSystem.all.each do |m|
      if m.diagnoses.any?
        seed_file << 'min = MinorSystem.find_by_name("'+m.name.to_s+'")' + "\n"
        m.diagnoses.each do |d|
          seed_file << '    diag = Diagnosis.find_by_name("'+d.name.to_s+'")' + "\n"
          seed_file << '    min.diagnoses << diag' + "\n"
        end
      end
    end

    MinorSystem.all.each do |m|
      if m.symptoms.any?
        seed_file << 'min = MinorSystem.find_by_name("'+m.name.to_s+'")' + "\n"
        m.symptoms.each do |s|
          seed_file << '    symp = Symptom.find_by_name("'+s.name.to_s+'")' + "\n"
          seed_file << '    min.symptoms << symp' + "\n"
        end
      end
    end

    MajorSystem.all.each do |m|
      if m.minor_systems.any?
        seed_file << 'maj = MajorSystem.find_by_name("'+m.name.to_s+'")' + "\n"
        m.minor_systems.each do |ms|
          seed_file << '    min = MinorSystem.find_by_name("'+ms.name.to_s+'")' + "\n"
          seed_file << '    maj.minor_systems << min' + "\n"
        end
      end
    end

    EvaluationTemplate.all.each do |e|
      if e.major_systems.any?
        seed_file << 'evtemp = EvaluationTemplate.find_by_name("'+e.name.to_s+'")' + "\n"
        e.major_systems.each do |ms|
          seed_file << '    maj = MajorSystem.find_by_name("'+ms.name.to_s+'")' + "\n"
          seed_file << '    evtemp.major_systems << maj' + "\n"
        end
      end
    end

    puts "Done!"

  end
end
