# lib/tasks/app.rake

namespace :app do

  desc "Display the application version"
  task :version do
    puts ENV['APP_VERSION']
  end

  # NOTE: the prestart tasks were extracted from start to support
  #       the use of an IDE such as Rubymine during development

  desc "Start All application components except for PUMA (useful for running Puma in a debugger)"
  task prestart: %w[ app:info prep:db assets:precompile im_gateway:start redis:start sidekiq:start]

  desc "Start ALL application components"
  task start: %w[ app:prestart puma:start ] 




  desc "Dump the System Environment Variables and /etc/hosts file to the console"
  task :info do
    puts "The System Environment Variables defined ..."
    puts ENV.ai(sort_keys:true)  # NOTE: ai() comes from the awesome_print gem
    puts "="*40
    hosts_file = WINDOWS ? 'c:\Windows\System32\drivers\etc\hosts' : '/etc/hosts'
    puts "Contents of the #{hosts_file} file ..."
    puts Pathname.new(hosts_file).read
  end


  desc "Stop ALL application components"
  task stop: %w[ puma:stop sidekiq:stop im_gateway:stop ]


  desc "Restart the App and all associated support programs"
  task :restart do
    STDERR.puts "=== Starting Maintenance Mode ==="
    Rake::Task["maintenance:start"].invoke
    Rake::Task["app:stop"].invoke
    Rake::Task["app:start"].invoke

    wait_seconds = 15  # NOTE: will have to play with this magic number to see what value works best
    STDERR.print "Waiting for #{wait_seconds} seconds for applications to stabilize ... "
    sleep(wait_seconds)
    STDERR.puts "done."

    Rake::Task["maintenance:end"].invoke
    STDERR.puts "=== Maintenance Mode is Over ==="
  end

end # namespace :app do
