
class CategorizedSelectors < Array
  # A CategorizedSelector implements some helper methods for the data structure 
  # needed for the form helper, option_groups_from_collection_for_select.
  #
  # A CateforizedSelectors object is as an Array of <optgroups>, 
  # in which each array element is itself an array: [<group-name>, [<group members>]]. 
  # In turn, each <group member> looks like [<selector title><selector value>].
  
  #E.g., 
  # [
  #  ["Musculoskeletal-Foot", [["Claw Foot (Pes Cavus)", 6]]],
  #  ["Skin", [["Acne", 12], ["Diabetes doc 2", 10], ["Diabetes milletues evaluation", 4]]],
  #  ["Unclassified", [["Conditional test", 11], ["Simple sample form", 5]]
  # 

def groups
  self.map{|x,y| x}
end

def group_selectors(group)
  self.select{|x,y| x == group}.first.last
end

end
