# CPP New Developer Startup Guide

Welcome to the team.  Below you will find information for onboarding, developer environment setup, and an intro into our processes (source control management, etc.).  This project like most Ruby projects has a mix of developers ranging from seasoned professionals to newbies who have never seen the Ruby language.  If you are a seasoned professional, forgive some of the stuff that seems obvious and of course, please contribute to the content of this document so that we might make it easier for the less experienced developer to get up to speed.


## Key Acronyms

* EVSS - Enterprise Veterans Self Service - The program managed by [CSRA](http://csra.com)
    * [Paul Simon](mailto:paul.simon@csra.com), Program Manager
    * [Sandi Middleton](mailto:sandi.middleton@csra.com), Deputy Program Manager
    * Key corporate partner: [Veracity](https://www.meetveracity.com/)
* CPP  - Community Provider Portal - The project within EVSS on which will be contributing
* CUI  - Clinician User Interface - The name of the legacy system within which the CPP project shares components


## New Developer On-boarding

### Request Bitbucket Access

Request access to the CUI codebase maintained as a `git` repository on an enterprise installation of bitbucket maintained by the VetsEZ team.  Access to this repository can be granted by:

* VetsEZ CUI Team lead Kurt Wellington [kurt.wellington@vetsez.com](mailto:kurt.wellington@vetsez.com)
* CSRA/CPP Developer Lead Dewayne VanHoozer [tommy.vanhoozer@csra.com](mailto:tommy.vanhoozer@csra.com)

* Access the repository using [https://bitbucket.vetsez.net/projects/CUI/](https://bitbucket.vetsez.net/projects/CUI/)

### Request Atlassian Suite Access (HipChat, Confluence, JIRA)

Edel Tabion ([edel.tabion@csra.com](mailto:edel.tabion@csra.com)) of CSRA can setup your Atlassian access.  Send her a message with your name, e-mail address, and that you are part of the EVSS/CPP team and need access to Hipchat, Confluence, and JIRA.

* Confluence (Wiki): [https://csra-evss.atlassian.net/wiki/display/PP/Community+Care+Provider+Portal](https://csra-evss.atlassian.net/wiki/display/PP/Community+Care+Provider+Portal)
* JIRA:    [https://csra-evss.atlassian.net/secure/RapidBoard.jspa?rapidView=194](https://csra-evss.atlassian.net/secure/RapidBoard.jspa?rapidView=194)
* Hipchat: [https://evss.hipchat.com/sign_in?d=%2Fchat](https://evss.hipchat.com/sign_in?d=%2Fchat)

### Request access to the multi-team slack channels on slack.com

Anyone on the combined team can send an invite to you to join TeamCUIva.

* Slack:   [https://teamcuiva.slack.com](https://teamcuiva.slack.com)


## Developer Environment Setup

Below, find the section that is appropriate for your development platform.

### Windows

#### Install Oracle Virtual Box and Ubuntu for developing

Download Oracle Virtual Box and Ubuntu   
* VirtualBox Windows hosts: [https://www.virtualbox.org/wiki/Downloads](https://www.virtualbox.org/wiki/Downloads)
* Ubuntu Download image: [https://www.ubuntu.com/download/desktop](https://www.ubuntu.com/download/desktop)


    1. Install VirutalBox and start it.
    2. Click New; this will create a virutal machine.
    3. Name section fill out name, Type: Linux, Version: Ubuntu(64-bit) 
    4. Memory size: This depends on computer memory. I used 8192 GB 
    5. Hard disk: use default "Create a virtual hard disk now" 
    6. Hard disk file type: VDI(VirtualBox Disk Image)
    7. Storage on physical hard disk: Dynamically allocation 
    8. File Location and size:  50 GB 
    9. Click start; a dialog will ask for location of Ubuntu Download image.  
    10. Install Ubuntu

Ubuntu is successfully installed.   
Complete installation by following Linux (Ubuntu) section.

### Linux (Ubuntu)

#### Install RVM, Ruby, Rails, Git, PostgreSQL, Redis

Open a terminal and type:

    sudo apt-get update
    sudo apt-get install git-core curl zlib1g-dev build-essential libssl-dev libreadline-dev libyaml-dev libsqlite3-dev sqlite3 libxml2-dev libxslt1-dev libcurl4-openssl-dev python-software-properties libffi-dev nodejs

    
#### rvm and Ruby 

    gpg --keyserver hkp://keys.gnupg.net --recv-keys 409B6B1796C275462A1703113804BB82D39DC0E3
    curl -sSL https://get.rvm.io | bash -s stable
    source ~/.rvm/scripts/rvm
    rvm install 2.3.3
    rvm use 2.3.3 --default
    ruby -v
The ruby version will display: `ruby 2.3.3p222`
Insert no document into .gemrc file    

    vi ~/.gemrc
Insert the following
    
    ---
    gem: --no-document
    
Update gem and install bundler
    
    gem update --system
    gem install bundler
    
#### Install git

    sudo apt-get update
    sudo apt-get install git
    git config --global user.name "user name"
    git config --global user.email "myemail@email.com"
    git config --global alias.co checkout
    git config --global alias.br branch
    
#### Install Rails
    
    sudo apt-get update
    curl -sL https://deb.nodesource.com/setup_4.x | sudo -E bash -
    sudo apt-get install -y nodejs
    gem install rails -v 4.2.3
    rails -v
Rails version is `Rails 4.2.3`

#### Install postgresql

    sudo sh -c "echo 'deb http://apt.postgresql.org/pub/repos/apt/ xenial-pgdg main' > /etc/apt/sources.list.d/pgdg.list"
    wget --quiet -O - http://apt.postgresql.org/pub/repos/apt/ACCC4CF8.asc | sudo apt-key add -
    sudo apt-get update
    sudo apt-get install postgresql-common
    sudo apt-get install postgresql-9.6 libpq-dev
    
 Create a user and change password
    
    sudo -u postgres createuser user -s
    sudo -u postgres psql
    postgres=# \password user
    postgres=# \du

#### Install Redis
    
    sudo apt-get update
    sudo apt-get install redis-server

#### Bug fix for terminal not loading libraries 

    1. Terminal -> Preferences -> Profile -> New
    2. Command -> select `Run command as a login shell` -> Close


Follow the remaining sections:

    Create a Working Directory 
    Install Git Hooks
    Updating the gemset
    Rake Tasks
    Starting the Application
    
### Mac User

The following information is for setting up a native development environment on a Macintosh platform.  This projects requires several 3rd party products not shipped with the MacOSX - or the version that is shipped with the OS is out of date.

#### Package Management - homebrew

On the Macintosh platform 3rd packages are managed by a non-Apple product.  There are several.  The one that is recommend system is `homebrew` also known as `brew` after its command line utility name.

Open a terminal window (/Applications/Utility/Terminal.app) - as a Macintosh-hosted developer you will like the iTerm product even better.  See [https://iterm2.com/](https://iterm2.com/)

Execute the following command:

    /usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"

The homebrew system install a command line utility called `brew` to use in the downloading, configuration, compiling and installing 3rd party products: Ruby, PostgreSQL and Redis.

The 3rd party products installed by `brew` are placed in `/usr/local/Cellar` with their binaries linked via `/usr/local/bin` so make sure that you have `/usr/local/bin` in your $PATH ahead of `/usr/bin`.

Install The latest versions of Ruby, PostgreSQL and Redis using this command:

    brew install ruby postgresql redis

As a software developer on the MacOSX you may also like these utilities:

    brew install git tree ack jump

To find out details on any brew managed products you can use the command `brew info zzz` to find out stuff about the 'zzz' utility - replace "zzz" with any space-seperated list of package names for which you want information.  By the way 'zzz' is a nice little tool to put your Mac to sleep from the cammand line.

##### Starting PostgreSQL and REdis

There are multiple ways to start and stop the database and key-value store utilities.  For example these two commands can be used to start the services:

    brew services start postgresql
    brew services start redis

PostgreSQL can also be started and stoped using the `pg_ctl` command line utility.

The Redis server can also be started with `redis-server` in any terminal window.


##### PostgreSQL User/Role Creation

TODO: This needs to be expanded.  Maybe `rake db:reset` is all that is needed even for the first time.

Create the default database superuser

    CREATE ROLE  whatever  WITH LOGIN PASSWORD 'pa$$w0rd_or_whatever';
    ALTER ROLE whatever SUPERUSER;

The database user and password values are fed into the application via environment variables `DBUSER` and `DBPASS` - actually a large number of configuration elements are fed into the application via system environment variables that are managed in files of the form `.env*` in the root directory of the project.  More on that later.


#### Managing Ruby Versions

The MacOSX version of Ruby is always out of date.  The version of Ruby that is installed via the `brew` package manager is generally the most recent stable version; however, the CPP project uses a version of Ruby that falls in between these two extreams.  The CPP projects is stuck on Ruby version 2.3.3.  On the MacOSX platform there are several ways of managing the different versions of Ruby.  The CPP project has chosen the [RVM project for Ruby Version Manangement](https://rvm.io/).

To install RVM follow the installation instructions at [https://rvm.io/](https://rvm.io/)

The CPP project makes use of the automated features of RVM to auto switch the Ruby version and assocated gemset when you enter into a CPP working directory.  More about that later when the installation of Ruby Gems (aka libraries) is discussed.

With RVM installed, install Ruby version 2.3.3 like this:

    rvm install 2.3.3

... after the configuration and compilation process has finished, make Ruby version 2.3.3 your default version:

    rvm use 2.3.3 --default

This will establish Ruby version 2.3.3 as your default Ruby and will create a "global" gemset.  A "gemset" is what RVM calls groups of gems.  For each Ruby project you can have different gemsets.  A gemset among other things speeds the loading of your projects by limited the number of installed "gems" (eg. libraries) that have to be searched during the loading process.

You can always update the versions of the gems in a gemset using this command:

    gem update

When you `cd` into a working directory on this project, RVM will automatically switch the version of Ruby to the version designated for the project and it will also enable the specific gemset established for the project.

###   Create a Working Directory 

Use the `git clone` command to create your working directory.  You may have several working directories on your workstation.  Its just a matter how you feel most comfortable in your git-based workflow.

You might do something like this in your user home directory:

    mkdir project_repos
    cd project_repos
    git clone https://yourusername@bitbucket.vetsez.net/scm/cui/cui.git cpp_develop
    cd cpp_develop
    git checkout cpp_develop

### Install Git Hooks

Since this is a brand new working directory there are some "git hooks" which need to be installed.  These shell scripts are found in the `hooks_for_git` subdirectory.  From the root directory of the working directory install them like this:

    cp -r hooks_for_git/* .git/hooks

At this time there are only two git hooks:

* commit-msg  -- prepends the git branch name to every git commit message
* post-merge  -- runs `bundle install` when the Gemfile changes as a result of a `git merge`

### Updating the gemset

When you entered the working directory via the `cd` command RVM switched your active Ruby version to the one specified in the file `.ruby-version` in the directory.  RVM will also setup the gemset that is specified in the `.ruby-gemset` file.  To complete the installation of the gemset you will need to do the following in the working directory.  You should only have to do this once:

    gem install bundler

The bundler gem manages all the gems associated with the project via the "Gemfile" and "Gemfile.lock" files.  After bundler is installed do this:

    bundle install

The `bundle` command line utility invokes the bundler gem to review the contents of the Gemfile and Gemfile.lock files.  It will either installed the gems for this project from the source location identified in the Gemfile or from the contents of the `vendor/cache` directory.

### Rake Tasks

With the working directory established, configured and updated there are "rake tasks" which are available for additional configuration.

To install the project's database schema and "seed" the test data you can do:

    rake db:reset

You can do local database backup and restore using:

    rake db:backup
    rake db:restore

### Starting the Application

There are several ways in which the application can be executed.  One is via a rake task.  The other is via a script in the bin subdirectory.  Both ways ASSUME that PostgreSQL is already running and configured with the project's schema and test data.

The rake task

    rake app:start

is what is used in the AWS and DOcker deployments.  Its not necessarily what you would want to use on your workstation; but, you can.  Review the file `lib/tasks/app.rake` to see exactly what the task does.  A quick summary is that the task makes use of the environment variables DBREST, DBMIGRATION and DBSEED in order to "prep" the database via the `rake prep:db` tasks.  `app:start` also assumes that the Redis server is already running.


The shell script in the bin directory may be the common way in which you start the application on your workstation.

    bin/start_app
    bin/stop_app

The `start_app` script only ASSUMES that the database is running.  Its starts all of the other services that are needed by the application.  For example `bin/start_app` will startup the `redis-server` and `bin/stop_app` will shut down the Redis server.


## Additional Developer Documentation

In your working directory this file and many other developer-oriented documentation files are maintained in the `doc` subdirectory.  In the `doc` subdirectory you will find entity relationship diagrams, many discussions about system environment variables and how they are used in the project.

### System Environment Variables

This project uses the gem `dotenv` to manage the values of system environment variables using files in the form `.env*` in the root directory of the project.  You will need to complete understand how these files are used within the project and how they relate to each other via the `RAILS_END` and `DEPLOY_TYPE` environment variables.

Any `.env*` file that ends with `.local` is a developer's local over-ride.  The `.env*.local` are NOT configuration managed.  THey are for your use on your local workstation.  Ask any of the other developers on this project if they mind sharing their local over-ride files with you.  That always a good starting place until you develop a feel for waht and how you want your development environment to behave.


# Guard

Get into the habit and development pattern of always running the `guard` utility in a seperate terminal window from where you are developing for this project.  The `guard` utility (actuall a set of gems) watches each of the source files in the project for changes.  When a file is changed `guard` will execute several different background tasks against that changed file.

The primary use of `guard` is to run static code analysis on changed files.  The results of the analysis is stored as HTML files in the `tmp` subdirectory.  You can have your browser open to the "current" HTML file which gives a report on how well (or how poorly) the static code analyzers think about the changed file.


# Docker

TODO: get over the desire to say "No don't use Docker!" and write something that is actually usable.

Docker containers are the means by which the application is deployed on Amazon Web Services (AWS) EC2 instances.  The deployment is handled by the VetsEZ configuration managment team.

As a developer you can run PostgreSQL, Redis and the application in docker containers.  This may be the preferred way for developers who have company-locked MS Windows-based workstations.

For details see the developer documentation in the `doc` subdirectory on how to user docker.

TODO: write something about how to use docker and put it into the `doc` subdirectory.


# Source Control and Branching Strategy

All feature, bugfix, etc. branches come from the `cpp_develop` branch.  Pull requests for a feature/bugfix branch are targeted back to the `cpp_develop` branch.  This project enjoys a peer review process in which every member of the software development team is a default review for every pull request.  The bitbucket repository has been configured to require two "approvals" from reviewers before a branch can be merged into the `cpp_develop` branch.

Branches with the prefix `cpp_` are controlled by the software development lead.

The feature/bugfix branches are simply named after the JIRA ticket to which they apply.  There is no need for extra verbiage in the branch name.  Anyone who needs to know details about a branch can look those details up in JIRA.  For example: ticket PP-445 has a branch PP-445 associated with it.

The `commit-msg` git hook will automatically prepends the branch name to all of your commit messages.  That way, because of our branch naming convention, you don't have to remember which ticket your commits are applied against - unless you happen to be working in a branch where you have also included a hotfix within that ticket that applies to a different ticket.  In that case, you will need to remember to include the second ticket in the commit message.  Always use upper case PP- in front of the integer number of the ticket.

If there are two tickets you are working concurrently because their implementation is tightly coupled you may create a branch name that references both tickets.  For example a branch name of `PP-123_PP-456` represents a branch in which both JIRA ticker PP-123 and PP-456 are being worked because of their implementation dependency.

