class AdjustIndexToLookupTables < ActiveRecord::Migration

  CSV_TABLE_NAMES = [
    :care_categories,
    :consultation_orders,
    :consultation_statuses,
    :consultation_types,
    :medical_specialties,
    :other_health_insurances,
    :referral_document_types,
    :referral_reasons,
    :referral_types,
    :visns,
    # :sites,
    # :diagnosis_codes
  ]

  def change
    AdjustIndexToLookupTables::CSV_TABLE_NAMES.each do |csv_table_name|
      begin
        remove_index  csv_table_name, :title
      rescue StandardError
        # means the index did not exist; but we're going to add it anyway
      end
      add_index     csv_table_name, :title, unique: false
    end

    remove_index  :diagnosis_codes, :version_code
    add_index     :diagnosis_codes, :version_code, unique: false

  end
end
