class SplitPatientName < ActiveRecord::Migration
  def change
    add_column :claims, :first_name, :string
    add_column :claims, :middle_name, :string
    add_column :claims, :last_name, :string
    add_column :claims, :date_of_birth, :date
    Claim.all.each do |claim|
      patient_name = claim.patient_name.split(" ")
      if patient_name.size > 1
        claim.last_name = patient_name.last
        claim.first_name = patient_name[0..-2].join(" ")
        claim.save
      end
    end
  end
end
