require 'uri'

APP_URL         = ENV['APP_URL']
uri             = URI(APP_URL)
HOST            = uri.host
PORT            = uri.port
HOST_WITH_PORT  = HOST.to_s + (PORT ? ":#{PORT}" : '')

DrTurboTax::Application.configure do
  # Settings specified here will take precedence over those in config/application.rb.

  # The test environment is used exclusively to run your application's
  # test suite. You never need to work with it otherwise. Remember that
  # your test database is "scratch space" for the test suite and is wiped
  # and recreated between test runs. Don't rely on the data there!
  config.cache_classes = true

  # Do not eager load code on boot. This avoids loading your whole application
  # just for the purpose of running a single test. If you are using a tool that
  # preloads Rails for running tests, you may have to set it to true.
  config.eager_load = false

  config.action_controller.default_url_options = { host: HOST_WITH_PORT }

  # Configure static asset server for tests with Cache-Control for performance.
  config.serve_static_files  = true
  config.static_cache_control = "public, max-age=3600"

  # Show full error reports and disable caching.
  config.consider_all_requests_local       = true
  config.action_controller.perform_caching = false

  # Raise exceptions instead of rendering exception templates.
  config.action_dispatch.show_exceptions = false

  # Disable request forgery protection in test environment.
  config.action_controller.allow_forgery_protection = false

  ##############################################################
  # ActionMailer Configuration

  config.action_mailer.raise_delivery_errors = true

  config.action_mailer.delivery_method = :smtp

  config.action_mailer.default_url_options = { host: HOST_WITH_PORT }

  config.action_mailer.smtp_settings = {
    address:              ENV['EMAIL_HOST'],
    port:                 ENV['EMAIL_PORT'],
    domain:               ENV['EMAIL_DOMAIN'],
    user_name:            ENV['EMAIL_USER'],
    password:             ENV['EMAIL_PASS'],
    authentication:       'plain',
    enable_starttls_auto: true
  }

  ##############################################################




  # Print deprecation notices to the stderr.
  config.active_support.deprecation = :stderr

  # The location of the Haml FML form templates
  config.form_views = File.join(File.dirname(__FILE__), "..", "..", "app", "views", "forms")

  # Use qunit-rails to set up a path for the qunit tests. Will be available at /qunit
  config.qunit.tests_path = "spec"
end
