# app/via_api/find_patient_service.rb
module VIA_API
  module FindPatientService

    class << self

      ##############################################################
      def mpi_lookup(ssn, vista_session)

        VIA_API.validate_vista_session(vista_session)
        request  = FINDPATIENT_CLIENT.build_request(:mpi_lookup, message: mpi_lookup_request(ssn,vista_session)).body
        request  = VIA_API.add_ser_prefix(request)
        response  = FINDPATIENT_CLIENT.call(:mpi_lookup, xml: request, soap_action: false)

        # Using Savon's default parsing to convert the soap response to a hash.

        data = response.body

        patient_raw_data = data.dig(:mpi_lookup_response, :patient_array, :patients, :patient_to)
        patient_raw_data_count = data.dig(:mpi_lookup_response, :patient_array, :count)
        fault_message = data.dig(:mpi_lookup_response, :patient_array, :fault)

        if fault_message.present?
          raise ViaApiFaultError.new(fault_message)
        end

        # NOTE: Using response.body for the get_appointments operation is not successful.
        #        Used Nokogiri as an alternative. It be standardized across the VIA_API module

        if patient_raw_data_count.to_i > 1
          patient_raw_data.each do |vet|
            veterans << VIA_API::Models::Veteran.new(vet)
          end
        else
          veterans = [VIA_API::Models::Veteran.new(patient_raw_data)]
        end

        return veterans
      end # def mpi_lookup


      def mpi_lookup_request(ssn, vista_session)

        request = {}

        request[:queryBean] = {
          provider: {
            name:           vista_session[:user_name],
            userId:         vista_session[:duz],
            loginSiteCode:  vista_session[:site_id]
          },
          criteria:             ssn,
          requestingApp:        ENV['VIA_REQ_APP'],
          consumingAppToken:    ENV['VIA_CONS_APP_TOKEN'],
          consumingAppPassword: ENV['VIA_CONS_APP_PASS']
        }

        return request
      end


      ##############################################################
      def match_by_name_city_state(vista_session)

        VIA_API.validate_vista_session(vista_session)
        request  = FINDPATIENT_CLIENT.build_request(:match_by_name_city_state_ms, message: match_by_name_city_state_request(vista_session)).body
        request  = VIA_API.add_ser_prefix(request)
        response  = FINDPATIENT_CLIENT.call(:match_by_name_city_state_ms, xml: request, soap_action: false)

        data = response.body

        patient_raw_data = data.dig(:match_by_name_city_state_ms_response, :tagged_patient_arrays,
                                   :arrays, :tagged_patient_array, :patients, :patient_to)
        patient_raw_data_count = data.dig(:match_by_name_city_state_ms_response, :tagged_patient_arrays,
                                   :arrays, :tagged_patient_array, :count)
        fault_message = data.dig(:match_by_name_city_state_ms_response, :tagged_patient_arrays, :fault)

        if fault_message.present?
          raise ViaApiFaultError.new(fault_message)
        end

        veterans = []

        if patient_raw_data_count.to_i > 1
          patient_raw_data.each do |vet|
            veterans << VIA_API::Models::Veteran.new(vet)
          end
        else
          veterans = [VIA_API::Models::Veteran.new(patient_raw_data)]
        end

        return veterans
      end # def match_by_name_city_state


      def match_by_name_city_state_request(vista_session)

        request = {}
        request[:queryBean]= {
         provider:{
          userId:         vista_session[:duz],
          name:           vista_session[:user_name],
          loginSiteCode:  vista_session[:site_id]
         },

         # FIXNE: hardcoded junk not good.
         name:            "LASTNAME,FIRSTNAME format search query",
         requestingApp:   ENV['VIA_REQ_APP'],
         target:          "Valid City Name",
         criteria:        "2-character US State abbreviation or valid US territory abbreviation"
        }

        return request
      end
    end # class << self
  end # module FindPatientService
end # module VIA_API
