# app/services/mvi/retrieve_person.rb
module MVI

  class << self

    ##############################################################
    def retrieve_person pid, request_id
      request = MVI_CLIENT.build_request(:prpa_in201305_uv02, attributes: MVI::MSG_TAG_ATTRIBUTES, message: retrieve_person_request(pid, request_id))
      request_xml = add_default_header(request.body)
      req_xml = remove_namespaces(request_xml)
      response  = MVI_CLIENT.call(:prpa_in201305_uv02, xml: req_xml)

      data = response.body

      fault_message = data.dig(:fault, :faultstring)
      if fault_message.present? 
        raise MviApiFaultError.new(fault_message)
      end

      ack_code = data.dig(:prpa_in201306_uv02, :acknowledgement, :type_code, :@code)
      query_code = data.dig(:prpa_in201306_uv02, :control_act_process, :query_ack, :query_response_code, :@code)

      if ack_code == "AE" && query_code == "AE"
        raise MviPersonNotFoundError.new("Veteran not found in MVI")
      elsif ack_code == "AR"
        raise MviApplicationReject.new("MVI Database down. Please try later.")
      end

      if ack_code == "AA" && query_code == "OK"
        person_data = data.dig(:prpa_in201306_uv02, :control_act_process, :subject, :registration_event, :subject1)
      end

      return person_data
    end

    def retrieve_person_request(pid, unique_request_id)
      unique_message_id = "MCID-CUI-" + SecureRandom.hex(3)
      pid_parameter = pid + "^PI" + "^200CORP" + "^USVBA"

      request = {
        :id => { :@root => "1.2.840.114350.1.13.0.1.7.1.1", :@extension => unique_request_id },
        :creationTime => { :@value => MVI.encode_mvi_date(Time.now) },
        :versionCode => { :@code => "3.5" },
        :interactionId => { :@root => "2.16.840.1.113883.1.6", :@extension => "PRPA_IN201305UV02" },
        :processingCode => { :@code => "T" },
        :processingModeCode => { :@code => "T" },
        :acceptAckCode => { :@code => "AL" },
        :receiver => { 
          :@typeCode => "RCV",
          :device => {
            :@classCode => "DEV", 
            :@determinerCode => "INSTANCE",
            :id => {
              :@root => "1.2.840.114350.1.13.999.234"
            },
            :telecom => {
              :@value => "http://servicelocation/PDQuery"
            }
          }
        },
        :sender => {
          :@typeCode => "SND",
          :device => {
            :@classCode => "DEV",
            :@determinerCode => "INSTANCE",
            :id => {
              :@extension => MVI::APP_NAME,
              :@root => "2.16.840.1.113883.4.349"
            }
          }
        },
        :controlActProcess => {
          :@classCode => "CACT",
          :@moodCode => "EVN",
          :dataEnterer => {
            :@typeCode => "ENT",
            :@contextControlCode => "AP",
            :assignedPerson => {
              :@classCode => "ASSIGNED",
              :id => {
                :@extension => MVI::APP_NAME,
                :@root => "2.16.840.1.113883.777.999"
              },
              :assignedPerson => {
                :@classCode => "PSN",
                :@determinerCode => "INSTANCE",
                :name => {
                  :given => "CUI Interface",
                  :family => "Submitter"
                }
              }
            }
          },
          :code => {
            :@code => "PRPA_TE201305UV02",
            :@codeSystem => "2.16.840.1.113883.1.6"
          },
          :queryByParameter => {
            :queryId => {
              :@root => "1.2.840.114350.1.13.28.1.18.5.999",
              :@extension => unique_message_id
            },
            :statusCode => {
              :@code => "new"
            },
            :modifyCode => {
              :@code => "MVI.COMP1"
            },
            :initialQuantity => {
              :@value => "1"
            },
            :parameterList => {
              :id => {
                :@extension => pid_parameter,
                :@root => "2.16.840.1.113883.4.349"
              },
              :otherIDsScopingOrganization => {
                :value => {
                  :@root => "1.2.840.114350.1.13.99997.2.3412",
                  :@extension => "VBA"
                },
                :semanticsText => "MVI.ORCHESTRATION"
              }
            }
          }
        }
      }
      request
    end  

  end
end
