class MusculoskeletalOtherEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Other', base_document: 'other.xml'

  def modify_document
    evaluation_root.xpath("msof:musculoskeletalOtherFacts/msof:musculoskeletalOtherDiagnoses/msof:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'msof', basename: 'musculoskeletalOther',
      after: 'musculoskeletalOtherDiagnoses', symptoms_element: 'musculoskeletalOtherSymptoms')

    add_parent_evaluations(evaluation, "//msof:musculoskeletalOtherFacts")
  end
end
