class MusculoskeletalKneeEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Knee', base_document: 'knee.xml'

  REQUIRED_EXAM_TO_XML_INTEGER_FIELD_MAP = [
    {"hasAnkylosisDegrees" => "ankylosisInflexionDegrees"},
    {"initialRomFlexion" => "flexionActualDegrees"},
    {"repetitiveRomFlexion" => "flexionDeLucaDegrees"},
    {"repeatedUseRomFlexion" => "flexionMitchellDegrees"},
    {"flareupRomFlexion" => "flexionFlareUpDegrees"},
    {"initialRomExtension" => "extensionActualDegrees"},
    {"repetitiveRomExtension" => "extensionDeLucaDegrees"},
    {"repeatedUseRomExtension" => "extensionMitchellDegrees"},
    {"flareupRomExtension" => "extensionFlareUpDegrees"}
  ]

  JOINTS_OBJECTIVE_EVIDENCE = [
    "disabilityFactorsExcessFatigabilityLeftKnee",
    "disabilityFactorsWeakenedMovementLeftKnee",
    "disabilityFactorsIncoordinationLeftKnee",
    "disabilityFactorsLackOfEnduranceLeftKnee",
    "objectiveFlareupsLeftKnee"
  ]

  OPTION_FIELDS = ["lateralInstability", "genuRecurvatum", "recurrentSubluxation", "semilumarCartilage", "tibiaFibula"]


  def modify_document
    form = FML::Form.from_json(evaluation.doc.to_json)

    JOINTS_OBJECTIVE_EVIDENCE.each do |joint_evidence|
      field = form.fields[joint_evidence]
      if field.value == true
        add_presentable_symptom(field.attrs["attrs"]["ratingCalculator"], "jf", "jointsObjectiveEvidence", "kf:kneeFacts", "jointsObjectiveEvidence")
      end
    end

    # set a jointsOtherDiagnosis based on the arthritis type, if there is arthritis
    if form.fields['hasArthritisLeftKnee'].value == true
      value = rating_calculator_options_match(form.fields['hasArthritisTypeLeftKnee'])
      add_presentable_symptom(value, 'jf', 'jointsOtherDiagnoses', '//kf:kneeFacts', 'jointsOtherDiagnoses')
    end

    # set the knee diagnosis if there is ankylosis #TODO: do we need to set isAnkylosisPJR here?
    if form.fields['hasAnkylosisLeftKnee'].value == true
      add_presentable_symptom(form.fields["hasAnkylosisLeftKnee"].value, "kf", nil, "//kf:kneeFacts", "kneeDiagnoses")
    end

    add_presentable_symptoms(namespace: 'kf', basename: 'knee', excluded_fields: OPTION_FIELDS + JOINTS_OBJECTIVE_EVIDENCE + ["hasArthritisTypeLeftKnee"])

    REQUIRED_EXAM_TO_XML_INTEGER_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      value = 0
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        value = form.fields[exam_field_name].value
      end
      fact_node = Nokogiri::XML::Node.new("kf:#{xml_field_name}", document)
      fact_node.content = value
      evaluation_root.xpath("kf:kneeFacts").first << fact_node
    end

    OPTION_FIELDS.each do |field_name|
      add_fact_node("kf:#{field_name}", form.fields[field_name].value, "kf:kneeFacts") if form.fields[field_name]
    end

    add_parent_evaluations(evaluation, "//kf:kneeFacts")
  end
end
