class MusculoskeletalHipEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Hip', base_document: 'hip.xml'

  EXAM_TO_XML_FIELD_MAP = [
    {"initialRomFlexion" => "flexionActualDegrees"},
    {"repetitiveRomFlexion" => "flexionDeLucaDegrees"},
    {"initialRomExtension" => "extensionActualDegrees"},
    {"repetitiveRomExtension" => "extensionDeLucaDegrees"},
    {"initialRomAbduction" => "abductionActualDegrees"},
    {"repetitiveRomAbduction" => "abductionDelucaDegrees"},
    {"initialRomAdduction" => "adductionActualDegrees"},
    {"repetitiveRomAdduction" => "adductionDelucaDegrees"},
    {"initialRomInternalRotation" => "internalRotationActualDegrees"},
    {"repetitiveRomInternalRotation" => "internalRotationDelucaDegrees"},
    {"initialRomExternalRotation" => "externalRotationActualDegrees"},
    {"repetitiveRomExternalRotation" => "externalRotationDelucaDegrees"}
  ]
  
  def modify_document
    evaluation_root.xpath("hif:hipFacts/hif:hipDiagnoses/hif:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'hif', basename: 'hip')
    form = FML::Form.from_json(evaluation.doc.to_json)
    EXAM_TO_XML_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("hif:#{xml_field_name}", document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("hif:hipFacts").first << fact_node
      end
    end

    add_parent_evaluations(evaluation, "//hif:hipFacts")
  end
end
