class MusculoskeletalFootEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Foot', base_document: 'foot.xml'
  LEFT = "LEFT"
  RIGHT = "RIGHT"

  def modify_document
    evaluationTitle = evaluation.evaluation_spec.title
    evaluation_root.xpath("cbsf:commonBodySystemFacts/cbsf:diagnoses/cbsf:value").first.content = evaluationTitle

    form = FML::Form.from_json(evaluation.doc.to_json)

     if evaluationTitle == "Flatfoot, acquired"
      addTag("cbsf", "symptoms", "", true)
    
      # ADD LEFT SYMPTOMS 
      #addPainOnUse(form, LEFT)  
      #addPainOnManipulation(form, LEFT)
      #addMildSymptoms(form, LEFT)
      #addModerateSymptoms(form, LEFT) 
      #addSevereSymptoms(form, LEFT)
      #addMarkedInwardDisplacement(form, LEFT)
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "characteristicCallosities", "characteristicCallositiesLeft", "characteristicCallositiesRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "extremeTendernessPlantar", "extremeTendernessPlantarLeft", "extremeTendernessPlantarRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "swellingOnUse", "swellingOnUseLeft", "swellingOnUseRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "inwardBowing", "inwardBowingLeft", "inwardBowingRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "inwardDisplacement", "inwardDisplacementLeft", "inwardDisplacementRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "markedPronation", "markedPronationLeft", "markedPronationRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "mildSymptoms", "mildSymptomsLeft", "mildSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "moderateSymptoms", "moderateSymptomsLeft", "moderateSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "markedDeformity", "markedDeformityLeft", "markedDeformityRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "painOnManipulation", "painOnManipulationLeft", "painOnManipulationRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "painOnManipulationAccentuated", "painOnManipulationAccentuatedLeft", "painOnManipulationAccentuatedRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "painOnUse", "painOnUseLeft", "painOnUseRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "painOnUseAccentuated", "painOnUseAccentuatedLeft", "painOnUseAccentuatedRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "pronouncedSymptoms", "pronouncedSymptomsLeft", "pronouncedSymptomsRight")
      addSevereSpasmSymptoms(form, LEFT)
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "severeSymptoms", "severeSymptomsLeft", "severeSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "archSupportEffect", "archSupportEffectLeft", "archSupportEffectRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "builtUpShoeEffect", "builtUpShoeEffectLeft", "builtUpShoeEffectRight")
      addDefaultLeftAndRightSymptonsTag(form, LEFT, "weightBearingLine", "weightBearingLineLeft", "weightBearingLineRight")

      # ADD RIGHT SYMPTOMS
      #addPainOnUse(form, RIGHT)
      #addPainOnManipulation(form, RIGHT)
      #addMildSymptoms(form, RIGHT)
      #addModerateSymptoms(form, RIGHT)
      #addSevereSymptoms(form, RIGHT)
      #addMarkedInwardDisplacement(form, RIGHT)
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "characteristicCallosities", "characteristicCallositiesLeft", "characteristicCallositiesRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "extremeTendernessPlantar", "extremeTendernessPlantarLeft", "extremeTendernessPlantarRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "swellingOnUse", "swellingOnUseLeft", "swellingOnUseRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "inwardBowing", "inwardBowingLeft", "inwardBowingRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "inwardDisplacement", "inwardDisplacementLeft", "inwardDisplacementRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "markedPronation", "markedPronationLeft", "markedPronationRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "mildSymptoms", "mildSymptomsLeft", "mildSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "moderateSymptoms", "moderateSymptomsLeft", "moderateSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "markedDeformity", "markedDeformityLeft", "markedDeformityRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "painOnManipulation", "painOnManipulationLeft", "painOnManipulationRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "painOnManipulationAccentuated", "painOnManipulationAccentuatedLeft", "painOnManipulationAccentuatedRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "painOnUse", "painOnUseLeft", "painOnUseRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "painOnUseAccentuated", "painOnUseAccentuatedLeft", "painOnUseAccentuatedRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "pronouncedSymptoms", "pronouncedSymptomsLeft", "pronouncedSymptomsRight")
      addSevereSpasmSymptoms(form, RIGHT)
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "severeSymptoms", "severeSymptomsLeft", "severeSymptomsRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "archSupportEffect", "archSupportEffectLeft", "archSupportEffectRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "builtUpShoeEffect", "builtUpShoeEffectLeft", "builtUpShoeEffectRight")
      addDefaultLeftAndRightSymptonsTag(form, RIGHT, "weightBearingLine", "weightBearingLineLeft", "weightBearingLineRight")
      
      #add_presentable_symptoms(namespace: 'cbsf', basename: 'commonBodySystem', root: nil, symptoms_element: 'symptoms', excluded_fields: ["painOnUse", "painOnUseLeftAccentuated", "painOnUseRightAccentuated", "mildSymptomsLeft", "mildSymptomsRight", "moderateSymptomsLeft", "moderateSymptomsRight", "severeSymptomsLeft", "severeSymptomsRight", "characteristicCallosities", "characteristicCallositiesLeft", "characteristicCallositiesRight", "severeSpasmAchillesImprovedByAppliancesLeft", "severeSpasmAchillesImprovedByOrthopedicShoesLeft", "severeSpasmAchillesImprovedByAppliancesRight", "severeSpasmAchillesImprovedByOrthopedicShoesRight", "inwardDisplacementLeft", "inwardDisplacementRight"])

     elsif evaluationTitle == "Claw foot, acquired"
      addTag("cbsf", "symptoms", "", true)
      
      addLeftSymptomsTag(form, "leftDroppedForefoot")
      addLeftSymptomsTag(form, "leftToes")
      addLeftSymptomsTag(form, "leftPainTenderness")
      addLeftSymptomsTag(form, "leftDorsiflexion")
      addLeftSymptomsTag(form, "leftPlantarFascitis")
      addLeftSymptomsTag(form, "leftSlight")

      addRightSymptomsTag(form, "rightDroppedForefoot")
      addRightSymptomsTag(form, "rightToes")
      addRightSymptomsTag(form, "rightPainTenderness")
      addRightSymptomsTag(form, "rightDorsiflexion")
      addRightSymptomsTag(form, "rightPlantarFascitis")
      addRightSymptomsTag(form, "rightSlight")


      #add_presentable_symptoms(namespace: 'cbsf', basename: 'commonBodySystem', root: nil, symptoms_element: 'symptoms', excluded_fields: ["leftDroppedForefoot", "leftToes", "leftPainTenderness", "leftDorsiflexion", "leftPlantarFascitis", "leftSlight", "rightDroppedForefoot", "rightToes", "rightPainTenderness", "rightDorsiflexion", "rightPlantarFascitis", "rightSlight"])

     elsif evaluationTitle == "Weak Foot"
      add_presentable_symptoms(namespace: 'cbsf', basename: 'commonBodySystem', root: nil, symptoms_element: 'symptoms', excluded_fields: [])
     else
       addTag("cbsf", "symptoms", "", true)
     end

    addTag("cbsf", "commonType", "Foot", false)
    add_parent_evaluations(evaluation, "//cbsf:commonBodySystemFacts")
  end

  private

  def addMarkedInwardDisplacement(form, side)
    addDefaultLeftAndRightSymptonsTag(form, side, "inwardDisplacement", "inwardDisplacementLeft", "inwardDisplacementRight")
  end

  def addCharacteristicCallosities(form, side)
    addDefaultLeftAndRightSymptonsTag(form, side, "characteristicCallosities", "characteristicCallositiesLeft", "characteristicCallositiesRight") 
  end
  
  def addMildSymptoms(form, side)
    addDefaultLeftAndRightSymptonsTag(form, side, "mildSymptoms", "mildSymptomsLeft", "mildSymptomsRight")
  end

  def addModerateSymptoms(form, side)
    addDefaultLeftAndRightSymptonsTag(form, side, "moderateSymptoms", "moderateSymptomsLeft", "moderateSymptomsRight")
  end

  def addSevereSymptoms(form, side)
    addDefaultLeftAndRightSymptonsTag(form, side, "severeSymptoms", "severeSymptomsLeft", "severeSymptomsRight")
    addSevereSpasmSymptoms(form, side)
  end

  def addSevereSpasmSymptoms(form, side)
    severeSpasmAchillesSelected = getValue(form, "severeSpasmAchilles")
    if severeSpasmAchillesSelected
      if side == LEFT
        severeSpasmAchillesLeftSelected = getValue(form, "severeSpasmAchillesLeft")
        puts "LEFT"
        puts severeSpasmAchillesLeftSelected
        if severeSpasmAchillesLeftSelected
          sSAImprovedByAppliancesLeftSelected = getValue(form, "severeSpasmAchillesImprovedByAppliancesLeft")
          if sSAImprovedByAppliancesLeftSelected
            addTag("cbsf", "leftSymptoms", getRatingCalculatorValue(form, "severeSpasmAchillesImprovedByAppliancesLeft"), true)
          end
      
          sSAImprovedByOrthopedicShoesLeftSelected = getValue(form, "severeSpasmAchillesImprovedByOrthopedicShoesLeft")
          if sSAImprovedByOrthopedicShoesLeftSelected
            addTag("cbsf", "leftSymptoms", getRatingCalculatorValue(form, "severeSpasmAchillesImprovedByOrthopedicShoesLeft"), true)
          end
        end
      end
      if side == RIGHT
        severeSpasmAchillesRightSelected = getValue(form, "severeSpasmAchillesRight")
        if severeSpasmAchillesRightSelected
          sSAImprovedByAppliancesRightSelected = getValue(form, "severeSpasmAchillesImprovedByAppliancesRight")
          if sSAImprovedByAppliancesRightSelected
            addTag("cbsf", "rightSymptoms", getRatingCalculatorValue(form, "severeSpasmAchillesImprovedByAppliancesRight"), true)
          end

          sSAImprovedByOrthopedicShoesRightSelected = getValue(form, "severeSpasmAchillesImprovedByOrthopedicShoesRight")
          if sSAImprovedByOrthopedicShoesRightSelected
            addTag("cbsf", "rightSymptoms", getRatingCalculatorValue(form, "severeSpasmAchillesImprovedByOrthopedicShoesRight"), true)
          end
        end
      end
    end
  end

  def addDefaultLeftAndRightSymptonsTag(form, side, parentField, childLeftField, childRightField)
    parentSelected = getValue(form, parentField)
    if parentSelected
      if side == "LEFT"
        leftSelected = getValue(form, childLeftField)
        if leftSelected
          ratingVal = getRatingCalculatorValue(form, childLeftField)
          if ratingVal != nil
            addTag("cbsf", "leftSymptoms", ratingVal, true)
          end
        end
      end
      if side == "RIGHT"
        rightSelected = getValue(form, childRightField)
        if rightSelected
          ratingVal = getRatingCalculatorValue(form, childRightField)
          if ratingVal != nil
            addTag("cbsf", "rightSymptoms", ratingVal, true)
          end
        end
      end
    end
  end

  def addPainOnManipulation(form, side)
    processPain(form, side, "painOnManipulation", "painOnManipulationLeftAccentuated", "painOnManipulationRightAccentuated")
  end

  def addPainOnUse(form, side)
    processPain(form, side, "painOnUse", "painOnUseLeftAccentuated", "painOnUseRightAccentuated")
  end

  def processPain(form, side, parent, childLeft, childRight)
    painOnUse = getValue(form, parent)
    if painOnUse
      painOnUseValue = getRatingCalculatorValue(form, parent)

      if side == LEFT
        painOnUseLeftAccentuated = getValue(form, childLeft)
        if painOnUseLeftAccentuated
          addTag("cbsf", "leftSymptoms", painOnUseValue, true)

          painOnUseLeftAccentuatedValue = getRatingCalculatorValue(form, childLeft)
          addTag("cbsf", "leftSymptoms", painOnUseLeftAccentuatedValue, true)
        end
      end

      if side == RIGHT
        painOnUseRightAccentuated = getValue(form, childRight)
        if painOnUseRightAccentuated
          addTag("cbsf", "rightSymptoms", painOnUseValue, true)

          painOnUseRightAccentuatedValue = getRatingCalculatorValue(form, childRight)
          addTag("cbsf", "rightSymptoms", painOnUseRightAccentuatedValue, true)
        end
      end
    end
  end
  
  def addTag(namespace, tagName, tagValue)
    addTag(namespace, tagName, tagValue, true)
  end

  def addTag(namespace, tagName, tagValue, addValueTag)
    evaluation_root.xpath("cbsf:commonBodySystemFacts").first << getTag(namespace, tagName, tagValue, addValueTag)
  end

  #def addSymptoms(tag, value)
    #addTag("cbsf", tag, value)
    #evaluation_root.xpath("cbsf:commonBodySystemFacts").first << getTag(namespace, tagName, tagValue)
  #end

  def getTag(namespace, tagName, tagValue, addValueTag)
    tag = Nokogiri::XML::Node.new(namespace+":"+tagName, document)
    
    if addValueTag
      valueTag = Nokogiri::XML::Node.new(namespace+":value", document)
      valueTag.content = tagValue
      tag << valueTag
    else
      tag.content = tagValue
    end
    tag
  end

  def addLeftSymptomsTagWithValue(fieldValue)
    addSymptomTag("leftSymptoms", fieldValue)
  end

  def addRightSymptomsTagWithValue(fieldValue)
    addSymptomTag("rightSymptoms", fieldValue)
  end

  def addLeftSymptomsTag(form, fieldName)
    addSymptomsTag(form, fieldName, "leftSymptoms")
  end

  def addRightSymptomsTag(form, fieldName)
    addSymptomsTag(form, fieldName, "rightSymptoms")
  end

  def addSymptomsTag(form, fieldName, tag)
    fieldSelected = getValue(form, fieldName)
    if fieldSelected
      fieldValue = getRatingCalculatorValue(form, fieldName)
      if fieldValue.to_s.strip.length > 0
        addTag("cbsf", tag, fieldValue, true)
      end
    end
  end

  def getValue(form, fieldName)
    form.fields[fieldName].value
  end

  def getRatingCalculatorValue(form, fieldName)
    fields = evaluation.evaluation_spec.ratings_calculator_fields.select do |h|
    if h[:name] == fieldName
        h
      end
    end
    filteredFieldValue = fields.collect do |ratings_calculator_field|
      form_field = form.fields[ratings_calculator_field[:name]]

      if form_field && (form_field.value == true || form_field.value == ratings_calculator_field[:calculator_value])
        ratings_calculator_field[:calculator_value]
      end
    end.compact
    filteredFieldValue[0]
  end
end
