class MusculoskeletalElbowEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Musculoskeletal-Elbow', base_document: 'elbow.xml'

  BOOLEAN_FIELDS = [
    ["dominantHand", ["Ambidextrous"], "ambidextrous"],
    ["dominantHand", ["Minor"], "minorExtremity"],
    ["dominantHand", ["Major"], "majorExtremity"],
    ["lossOfPronation", ["Motion loss beyond the middle of the arc", "Motion loss beyond last quarter of arc, the hand does not approach full pronation"], "completeLossPronation"],
    ["lossOfSupination", ["true"], "completeLossSupination"]
  ]
  EXAM_TO_XML_FIELD_MAP = [
    {"initialRomFlexion" => "flexionActualDegrees"},
    {"repetitiveRomFlexion" => "flexionDeLucaDegrees"},
    {"initialRomExtension" => "extensionActualDegrees"},
    {"repetitiveRomExtension" => "extensionDeLucaDegrees"},
    {"hasAnkylosisDegrees" => "ankylosisDegrees"},
    {"initialRomForearmSupination" => "supinationActualDegrees"},
    {"repetitiveRomSupination" => "supinationDeLucaDegrees"},
    {"initialRomForearmPronation" => "pronationActualDegrees"},
    {"repetitiveRomPronation" => "pronationDeLucaDegrees"}
  ]
  #"forearmDiagnosis"
  #"otherDiagnosis"
  
  def modify_document
    evaluation_root.xpath("elbf:elbowFacts/elbf:elbowDiagnoses/elbf:value").first.content = evaluation.evaluation_spec.title
    add_presentable_symptoms(namespace: 'elbf', basename: 'elbow')
    form = FML::Form.from_json(evaluation.doc.to_json)
    BOOLEAN_FIELDS.each do |boolean_field|
      if boolean_field[1].include?(form.fields[boolean_field[0]].value)
        boolean_node = Nokogiri::XML::Node.new("elbf:#{boolean_field[2]}", document)
        boolean_node.content = "true"
        evaluation_root.xpath("elbf:elbowFacts").first << boolean_node
      end
    end
    EXAM_TO_XML_FIELD_MAP.each do |fact|
      exam_field_name = fact.keys.first
      xml_field_name = fact[exam_field_name]
      if form.fields[exam_field_name] && form.fields[exam_field_name].to_h.has_key?(:value)
        fact_node = Nokogiri::XML::Node.new("elbf:#{xml_field_name}", document)
        fact_node.content = form.fields[exam_field_name].value
        evaluation_root.xpath("elbf:elbowFacts").first << fact_node
      end
    end

    add_parent_evaluations(evaluation, "//elbf:elbowFacts")
  end
end
