class FullbodyEvaluationPresenter < EvaluationPresenter
  presenter_for bodySystem: 'Fullbody', base_document: 'full_body.xml'


  def add_the_body_fact_elements_to_the_evaluation_data_node
    @the_body_facts_element_for.each do |the_key, the_facts_node|
      if the_facts_node != nil
        add_a_child_at_the_beginning_of_the_evaluation_data_node(the_facts_node)
      end
    end
  end

  
  def add_the_document_type_version_info
    #get the version info from the form
    #modify the existing DocumentTypeVersion OR add a DocumentTypeVersion
  end

  
  def add_the_evaluation_data_element_info_to_the_evaluation_data_node
    process_the_fields_from_the_current_evaluation_form
    build_the_body_fact_elements
    add_the_body_fact_elements_to_the_evaluation_data_node
  end

  
  def build_the_body_fact_elements
    @the_diagnosis_node_for.each do |the_diagnosis_code,the_diagnosis_node|
      the_diagnostic_info = THE_DIAGNOSTIC_CODE_TO_DIAGNOSTIC_INFO_MAPPING[the_diagnosis_code]
      if @the_body_facts_element_for[the_diagnostic_info[:bodyFactsName]] == nil
        @the_body_facts_element_for[the_diagnostic_info[:bodyFactsName]] = a_new_body_facts_node(the_diagnostic_info[:bodyFactsName])
      end
      @the_body_facts_element_for[the_diagnostic_info[:bodyFactsName]] << the_diagnosis_node
      @the_symptom_nodes_for[the_diagnosis_code].each do |the_symptom_node_to_add|
        @the_body_facts_element_for[the_diagnostic_info[:bodyFactsName]] << the_symptom_node_to_add
      end
    end
  end
  
  
  def initialize(evaluation, struct)
    super #call the overriden 'initialize' from the parent class
    @the_body_facts_element_for = Hash.new(nil)
    @the_diagnosis_node_for = Hash.new(nil)
    @the_symptom_nodes_for = Hash.new(nil)
  end


  def modify_document
    add_the_document_type_version_info
    add_the_claim_id_to_the_claim_id_node
    add_the_evaluation_data_element_info_to_the_evaluation_data_node
  end

 
  def process_a_diagnosis_field(the_diagnostic_code)
    the_diagnostic_info = THE_DIAGNOSTIC_CODE_TO_DIAGNOSTIC_INFO_MAPPING[the_diagnostic_code]

    the_diagnosis_container_node = a_new_xml_node(the_diagnostic_info[:namespace], the_diagnostic_info[:diagnosisElementName])
    the_diagnosis_value_node = a_new_xml_node(the_diagnostic_info[:namespace], 'value')
    the_diagnosis_value_node.content = the_diagnostic_info[:diagnosisValue]
    the_diagnosis_container_node << the_diagnosis_value_node

    @the_diagnosis_node_for[the_diagnostic_code]=the_diagnosis_container_node

    if @the_symptom_nodes_for[the_diagnostic_code]==nil
      @the_symptom_nodes_for[the_diagnostic_code] = Array.new
    end
  end

  
  def process_a_symptom_field(the_diagnostic_codes, the_symptom_value)
    the_diagnostic_codes.split(',').each do |the_diagnostic_code|
      the_diagnostic_info = THE_DIAGNOSTIC_CODE_TO_DIAGNOSTIC_INFO_MAPPING[the_diagnostic_code]

      the_symptom_container_node = a_new_xml_node(the_diagnostic_info[:namespace], the_diagnostic_info[:symptomElementName])
      the_symptom_value_node = a_new_xml_node(the_diagnostic_info[:namespace], 'value')
      the_symptom_value_node.content = the_symptom_value
      the_symptom_container_node << the_symptom_value_node

      if @the_symptom_nodes_for[the_diagnostic_code]==nil
        @the_symptom_nodes_for[the_diagnostic_code] = Array.new
      end

      @the_symptom_nodes_for[the_diagnostic_code] << the_symptom_container_node
    end
  end


  def process_the_fields_from_the_current_evaluation_form
    @the_current_evaluation_form.fields.each do |the_current_field|
      if (the_current_field[1].attrs['attrs']['usage'] == 'diagnosis') && (the_current_field[1].value != nil)
        process_a_diagnosis_field(the_current_field[1].attrs['attrs']['diagnosticCode'])
      end
      if (the_current_field[1].attrs['attrs']['usage'] == 'symptom') && (the_current_field[1].value != nil)
        process_a_symptom_field(the_current_field[1].attrs['attrs']['diagnosticCodes'],the_current_field[1].attrs['attrs']['symptomValue'])
      end
    end
  end
  
  
 
  THE_DIAGNOSTIC_CODE_TO_DIAGNOSTIC_INFO_MAPPING =
  {
  # MUSCULOSKELETAL SYSTEM
  # ORGANS OF SPECIAL SENSE
    '6090' => { :diagnosisValue => 'Diplopia', :namespace => 'eyef', :bodyFactsName => 'eyeFacts', :diagnosisElementName => 'eyeDiagnoses', :symptomElementName => 'eyeSymptoms' },
  # IMPAIRMENT OF AUDITORY ACUITY
  # INFECTIOUS DISEASES, IMMUNE DISORDERS, AND NUTRITIONAL DEFICIENCIES
  # RESPIRATORY SYSTEM
  # - Diseases of the Nose and Throat
  # - Diseases of the Trachea and Bronchi
  # - Diseases of the Lungs and Pleura - Tuberculosis
  # - Nontuberculous Diseases
  # - Bacterial Infections of the Lung
  # - Interstitial Lung Disease
  # - Mycotic Lung Disease
  # - Restrictive Lung Disease
    '6847' => { :diagnosisValue => 'Sleep apnea syndrome', :namespace => 'rf', :bodyFactsName => 'respiratoryFacts', :diagnosisElementName => 'respiratoryDiagnoses', :symptomElementName => 'respiratorySymptoms'  }
  # CARDIOVASCULAR SYSTEM
  # DIGESTIVE SYSTEM
  # GENITOURINARY SYSTEM
  # GYNECOLOGICAL CONDITIONS AND DISORDERS OF THE BREAST
  # HEMIC AND LYMPHATIC SYSTEMS
  # SKIN
  # ENDOCRINE SYSTEM
  # NEUROLOGICAL CONDITIONS AND CONVULSIVE DISORDERS
  # MENTAL DISORDERS
  # DENTAL AND ORAL CONDITIONS
  }
  
 
end
