# == Schema Information
#
# Table name: referral_appointments
#
#  id               :integer          not null, primary key
#  content          :json
#  created_at       :datetime         not null
#  updated_at       :datetime         not null
#  referral_id      :integer
#  appointment_time :datetime
#  added_to_cprs_at :datetime
#  added_to_cprs_id :integer
#

class ReferralAppointment < ActiveRecord::Base

  belongs_to :referral
  belongs_to :added_to_cprs_user, class_name: 'User', foreign_key: 'added_to_cprs_id', validate: true

  validates_presence_of :appointment_type, :appointment_time

  autowire_content_fields :appointment_type, :scheduled_by, :book_notes, :purpose, :appointment_end_time

  scope :needs_reminder, -> {where("appointment_time >= ? AND appointment_time <= ?",
                      (Time.now - 3.days).beginning_of_day, (Time.now - 1.days).end_of_day) }

  APPOINTMENT_TIME_FORMAT = '%m/%d/%Y %H:%M %p'

  def added_to_cprs?
    added_to_cprs_at.present?
  end

  def added_to_cprs_username
    added_to_cprs_user.try! :name
  end

  def vista_appointment?
    false
  end

  # returns an array of fields that appear in 'Details' section of appointment datatable
  def details
    [scheduled_by, referral.referral_type.title]
  end

end
