# == Schema Information
#
# Table name: major_systems
#
#  id                     :integer          not null, primary key
#  name                   :string
#  label                  :string
#  created_at             :datetime         not null
#  updated_at             :datetime         not null
#  evaluation_template_id :integer
#  position               :integer
#

class MajorSystem < ActiveRecord::Base

  has_many :minor_systems
  belongs_to :evaluation_template
  validates_presence_of :name
  validates_presence_of :label
  scope :order_by_position_asc, -> (){ all.order("position ASC") }
  scope :order_by_position, -> () { order("position ASC") }

  def build_html
    @maj_html = MAJOR_SYSTEM_HTML.clone
    @maj_html.gsub!('[Major System Name]', self.name)
    @maj_html.gsub!('[Major System Label]', self.label)
    min_html = ""
    self.minor_systems.order_by_position.each do |min|
      min_html += min.build_html
    end
    @maj_html.gsub!('[HTML from each Associated Minor System here]', min_html.html_safe)
    return @maj_html
  end

  def base_html
    return MAJOR_SYSTEM_HTML
  end



  MAJOR_SYSTEM_HTML = '<div id="outer_container-major_system-[Major System Name]" class="container major-system outer small-12 columns">
	<input 	id="visibility-major_system-[Major System Name]" name="visibility-major_system-[Major System Name]" type="checkbox" value="checked" visibility_dependents="inner_container-major_system-[Major System Name]" onchange="Set_Dependent_Visibility_Based_On(this);">
	<label  for="visibility-major_system-[Major System Name]">
		[Major System Label]
	</label>
	<div id="inner_container-major_system-[Major System Name]" class="container major-system inner small-12 columns hidden">

		[HTML from each Associated Minor System here]

	</div>
</div>  '



end
