# == Schema Information
#
# Table name: facilities
#
#  id      :integer          not null, primary key
#  name    :string
#  content :json
#  visn_id :integer
#

class Facility < ActiveRecord::Base
  belongs_to :visn

  has_many :providers

  autowire_content_fields :address, :city, :state, :zip, :phone

  def visn_region_prepended_name
    "#{visn.region}: #{self.name}"
  end

end
