# == Schema Information
#
# Table name: evaluation_templates
#
#  id         :integer          not null, primary key
#  name       :string
#  created_at :datetime         not null
#  updated_at :datetime         not null
#  label      :string
#

class EvaluationTemplate < ActiveRecord::Base
  has_many :major_systems
  validates_presence_of :name
  validates_presence_of :label

  FIELDS_FOR_RESULTSET = {
    0 => 'evaluation_templates.name',
    1 => 'evaluation_templates.label'
  }

  @html_repository = nil

  after_initialize :load_the_html_repository

  def form
    @html_repository.document_fragment
  end

  def build_html
    @template_html = ""
    self.major_systems.order_by_position.each do |maj|
      @template_html += maj.build_html + " \n <br> \n "
    end
    return @template_html
  end

  def load_html_repository
    the_repository_name = 'template_for_' + self.name
    html_repository = NokogiriEnabledHtmlRepository.find_or_create_by(name: the_repository_name)
    the_html_string = build_html
    the_fragment = Nokogiri::HTML::DocumentFragment.parse(the_html_string)
    html_repository.stores(the_fragment)
    return html_repository
  end

  class << self
    def filter(params={})

      query = EvaluationTemplate.all

      unless params[:search][:value].blank?
        query = filter_using_ev(params, query)
      end

      return query
    end

    def filter_using_ev(cp, q)
      q.where('name ilike :search OR label ilike :search', :search => "%#{cp[:search][:value]}%")
    end
  end

private

  def load_the_html_repository
    if self.name
      the_repository_name = 'template_for_' + self.name
      @html_repository = NokogiriEnabledHtmlRepository.find_or_create_by(name: the_repository_name)
    end
  end

end
