## == Schema DbqInformation
#
#  Table name: dbq_informations
#  identifier            :string
#  title                 :string
#  created_at            :datetime         not null
#  updated_at            :datetime         not null

class DbqInformation < ActiveRecord::Base
  has_many  :boilerplate_messages, through: :boilerplate_messages_dbq_informations,
            dependent: :destroy
  has_many  :boilerplate_messages_dbq_informations
  has_many  :contentions, through: :contentions_dbq_informations, dependent: :destroy
  has_many  :contentions_dbq_informations
  has_many  :symptoms, through: :symptoms_dbq_informations, dependent: :destroy
  has_many  :symptoms_dbq_informations
  has_many  :diagnoses, through: :diagnoses_dbq_informations, dependent: :destroy
  has_many  :diagnoses_dbq_informations
  has_many  :general_questions, through: :general_questions_dbq_informations, dependent: :destroy
  has_many  :general_questions_dbq_informations

  validates :identifier, :title, presence: true

  def creates_a_unique_boilerplate_message_association_with(the_boilerplate_message_to_use)
    if ( the_boilerplate_message_to_use.is_a?(BoilerplateMessage) )
      unless self.boilerplate_messages.exists?(the_boilerplate_message_to_use.id)
        self.boilerplate_messages << the_boilerplate_message_to_use
        the_boilerplate_message_to_use.reload
        self.reload
      end
    end
  end

  def creates_a_unique_contention_association_with(the_contention_to_use)
    if ( the_contention_to_use.is_a?(BoilerplateMessage) )
      unless self.contentions.exists?(the_contention_to_use.id)
        self.contentions << the_contention_to_use
        the_contention_to_use.reload
        self.reload
      end
    end
  end

  def creates_a_unique_symptom_association_with(symptom_to_use)
    if (symptom_to_use.is_a?(BoilerplateMessage))
      unless self.symptoms.exists?(symptom_to_use.id)
        self.symptoms << symptom_to_use
        symptom_to_use.reload
        self.reload
      end
    end
  end

  def creates_a_unique_diagnosis_association_with(diagnosis_to_use)
    if (diagnosis_to_use.is_a?(BoilerplateMessage))
      unless self.diganoses.exists?(diagnosis_to_use.id)
        self.diganoses << diagnosis_to_use
        diagnosis_to_use.reload
        self.reload
      end
    end
  end

  def creates_a_unique_gq_association_with(gq_to_use)
    if (gq_to_use.is_a?(BoilerplateMessage))
      unless self.general_questions.exists?(gq_to_use.id)
        self.general_questions << gq_to_use
        gq_to_use.reload
        self.reload
      end
    end
  end

end