# == Schema Information
#
# Table name: clinics
#
#  id         :integer          not null, primary key
#  site_id    :integer
#  clinic_id  :integer
#  name       :string
#  created_at :datetime         not null
#  updated_at :datetime         not null
#  deleted_at :datetime
#

class Clinic < ActiveRecord::Base
  acts_as_paranoid
  
  # Class Methods
  class << self

    # Get clinic id from user passed, using user preferences to get site.
    # NOTE: Currently sites have only one clinic.  This functionality will
    # change if we allow sites (facilities in VISTA) to have multiple clinics.
    def get_clinic_from_user(user)
      if user.is_vha_cc?
        site_id = user.user_preference.vista_site_id
        Clinic.where(site_id: site_id).first
      end
    end

  end

end
