## == Schema BoilerplateMessage
#
#  Table name: boilerplate_messages
#
#  name                  :string
#  content               :string
#  created_at            :datetime         not null
#  updated_at            :datetime         not null

class BoilerplateMessage < ActiveRecord::Base
  has_many :dbq_informations, through: :boilerplate_messages_dbq_informations
  has_many :boilerplate_messages_dbq_informations

  validates :name, :content, presence: true
  validates :name, uniqueness: true

  def creates_a_unique_dbq_information_association_with(dbq_information_object)
    if dbq_information_object.is_a?(DbqInformation)
      unless self.dbq_informations.exists?(dbq_information_object.id)
        self.dbq_informations << dbq_information_object
        dbq_information_object.reload
        self.reload
      end
    end
  end

end