class Ability
  include CanCan::Ability

  def initialize(user)
#cs binding.pry #cs
    user ||= User.new

    cannot :all

    if user.is_site_user?
      can [:index, :site_request], :landing
    end

    if user.is_supervisor?
      # Claims are open books to Supervisors
      can :manage, Claim

      # can create and view any Contention
      can [:new, :create, :show, :edit, :update, :resolve], Contention

      # can :accept resolved contentions
      can [:accept], Contention do |contention|
        contention.resolved?
      end

      # can create and view any evaluation
      can [:new, :create, :show, :review, :complete, :activity], Evaluation
      # can only edit and update their evaluations
      can [:edit, :update, :autosave], Evaluation, user: user

      can :create, Rejection
    end

    if user.is_medical_assistant?
      # Claims are open books to MAs
      can :manage, Claim

      # allow them to create or view contentions
      can [:new, :create, :show], Contention

      # except for viewing them
      can [:show, :create, :destroy, :activity], Evaluation
    end

    if user.is_examiner?
      can [:index, :show, :edit, :update, :details], Claim
      can [:show, :edit, :update, :resolve], Contention

      # can only work on new or their owned evaluations
      can [:new, :create, :show, :edit, :update, :autosave, :destroy, :activity], Evaluation, user: user

      can [:review, :complete], Evaluation
    end

    # VHA-only CPP (Provider Portal) functionality
    if user.is_vha_cc?
      can :manage, Referral
      can :manage, ReferralAppointment
      can :manage, ReferralDocument
      can :manage, Consultation
    end

    # VHA and Non-VHA CPP (Provider Portal) functionality
    if user.is_cpp_user?
      can [:index, :filter_by_quicklink, :search, :export, :show, :new, :edit,
           :create, :update, :destroy, :submit_for_va_review,
           :reset_referral_filter, :paged_list, :return_va], Referral
      can [:create, :destroy, :update], ReferralAppointment
      can :manage, ReferralNote
      can [:create, :delete, :approved?, :visible?, :update], ReferralDocument
      can :manage, Provider
      can :index, FaqController
    end

    # allow all non-CPP users to access Claims index page (root), to prevent
    #  users without any permissions from being unable to log into application.
    unless user.is_cpp_user?
      can [:index], Claim
    end

    if user.is_app_admin?
      can [:index, :show, :new, :create, :edit, :update, :site_request, :new_site_user, :manage_supervisors], :user
      can :manage, [:landing, :report]
      can :manage, [Dashboard, User, Site, Alert, Evaluation, EvaluationTemplate]
      can [:index, :show, :new, :create, :update, :access_requests,:access_request, :paged_list], :person
      can [:index, :show, :new, :create, :access_requests], :site
    end

    if user.has_this_role_on_any_site?('Admin')
      can :manage, [:landing, :report]
      can :manage, [Dashboard, Site, Alert, Evaluation, EvaluationTemplate, User]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
           :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
           :schedule_examination, :review_examination, :modify, :create, :assign_clinician,
           :change_site, :create_old, :update, :internal_cancel_examination], :examination_processor
      can [:index, :show, :new, :create, :edit, :update, :site_request, :new_site_user, :manage_supervisors], :user
      can [:index, :show, :update, :access_requests,:access_request], :person
    end

    if user.has_this_role_on_any_site?('Triage')
      can :manage, [:landing, :report]
      can [:index, :new, :view_exam_request, :ack, :ack_submit,
           :cancelExamRequest, :cancel_submit, :view_cancelled_exam_request,
           :loadContentions, :prepareExamRequestData, :getMaskedSsn,
           :get_clarification, :handleGetClarification, :clarification_info_submit,
           :createContentionDetail, :buildClarificationRequest, :redirectToHandleGetClarification,
           :select_contentions_submit, :view_contention, :create, :create_exams, :change_site], ExamRequest
      can [:index, :show, :new, :edit, :create, :update], :examination
      can :manage, [Dashboard, Site, Alert]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
           :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
           :review_examination, :modify, :create, :assign_clinician,
           :change_site, :create_old, :update, :internal_cancel_examination], :examination_processor
      can [:access_request], :person
      can [:create], :full_body_evaluation

      # This doesn't seem to work. Added check_ability method to full_body_evaluations controller
      cannot [:edit], :full_body_evaluation
      cannot [:schedule_examination], :examination_processor
    end

    if user.has_this_role_on_any_site?('Scheduling')
      can :manage, [Dashboard, Site, Alert]
      can :manage, [:landing, :report]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
       :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
       :schedule_examination, :review_examination, :modify, 
       :change_site, :update, :internal_cancel_examination, :verify_veteran_registration, :veteran_retrieval], :examination_processor
      can [:access_request], :person

      cannot [:assign_clinician], :examination_processor
    end

    if user.has_this_role_on_any_site?('Clinician')
      can :manage, [:landing, :report]
      can [:index, :new, :view_exam_request, :ack, :ack_submit,
           :cancelExamRequest, :cancel_submit, :view_cancelled_exam_request,
           :loadContentions, :prepareExamRequestData, :getMaskedSsn,
           :get_clarification, :handleGetClarification, :clarification_info_submit,
           :createContentionDetail, :buildClarificationRequest, :redirectToHandleGetClarification,
           :select_contentions_submit, :view_contention, :change_site], ExamRequest
      can [:index, :show, :new, :edit, :update], Examination
      can :manage, [Dashboard, Site, Alert, Evaluation]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
           :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
           :review_examination, :modify, :create, :assign_clinician,
           :change_site, :create_old, :update, :internal_cancel_examination], :examination_processor
      can [:access_request], :person

      cannot [:schedule_examination], :examination_processor
    end

    if user.has_this_role_on_any_site?('Supervisory Clinician')
      can :manage, [:landing, :report]
      can [:index, :new, :view_exam_request, :ack, :ack_submit,
           :cancelExamRequest, :cancel_submit, :view_cancelled_exam_request,
           :loadContentions, :prepareExamRequestData, :getMaskedSsn,
           :get_clarification, :handleGetClarification, :clarification_info_submit,
           :createContentionDetail, :buildClarificationRequest, :redirectToHandleGetClarification,
           :select_contentions_submit, :view_contention], ExamRequest
      can [:index, :show, :new, :edit, :update], Examination
      can :manage, [Dashboard, Site, Alert, Evaluation]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
           :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
           :schedule_examination, :review_examination, :modify, :create, :assign_clinician,
           :change_site, :create_old, :update, :internal_cancel_examination], :examination_processor
      can [:access_request], :person
    end

    if user.has_this_role_on_any_site?('Quality Assurance')
      can :manage, [:landing, :report]
      can [:index, :new, :ack, :ack_submit,
           :cancelExamRequest, :cancel_submit, :view_cancelled_exam_request,
           :loadContentions, :prepareExamRequestData, :getMaskedSsn,
           :get_clarification, :handleGetClarification, :clarification_info_submit,
           :createContentionDetail, :buildClarificationRequest, :redirectToHandleGetClarification,
           :select_contentions_submit, :view_contention, :change_site], ExamRequest
      can [:index, :show, :new, :edit, :create, :update], Examination
      can :manage, [Dashboard, Site, Alert, Evaluation]
      can [:index, :show, :edit, :view_examination, :cancel_examination,
           :ack, :ack_submit, :reschedule, :reschedule_submit, :cancelled_examination,
           :schedule_examination, :review_examination, :modify, :create, :assign_clinician,
           :change_site, :create_old, :update, :internal_cancel_examination], :examination_processor
      can [:access_request], :person
    end

  end
end
