require 'httpi'

class VlerDASJob < ActiveJob::Base
  queue_as :rendering

  def self.perform(evaluation)
    evaluation_xml = evaluation.to_xml
    activity_log = EvaluationLog.new(submitted_data: evaluation_xml, evaluation_id: evaluation.id, message: "VLER-DAS evaluation submission")
    validation_errors = evaluation.validate_xml
    if evaluation.complete?
      url = ENV['VLER_DAS_EXAM_RESPONSE_URL']
      if url != nil && url.length > 0
        validation_errors = evaluation.validate_xml
        if validation_errors.empty?
          req = build_request(url, evaluation_xml, "cui-#{evaluation.guid}.xml")
          response = HTTPI.post(req)
          activity_log.response_body = response.body
        else
          activity_log.message = validation_errors.join("; ")
        end
      end
    else
      activity_log.message = "Evaluation is not complete."
    end
    activity_log.save
  end

  def self.sendExamResponse(full_body_evaluation)
    full_body_evaluation.exam_responses.each do |the_exam_response_to_send|
      self.builds_and_sends_a_single_exam_response_message( full_body_evaluation.id,
                                                            "cui-#{full_body_evaluation.guid}.xml",
                                                            the_exam_response_to_send               )
    end
#    evaluation_xml = full_body_evaluation.to_xml
#    activity_log = EvaluationLog.new(submitted_data: evaluation_xml, evaluation_id: full_body_evaluation.id, message: "VLER-DAS evaluation submission")
#    url = ENV['VLER_DAS_URL']
#    url = "https://silvervler.va.gov/ecrud/v1/core/examResponse/transform"
#    #validation_errors = evaluation.validate_xml
#    req = build_request(url, evaluation_xml, "cui-#{full_body_evaluation.guid}.xml")
#    response = HTTPI.post(req)
#    activity_log.response_body = response.body
#    activity_log.save
  end

  def self.builds_and_sends_a_single_exam_response_message(the_id, the_file_name, the_exam_response_string)
    activity_log = EvaluationLog.new( submitted_data: the_exam_response_string,
                                      evaluation_id: the_id,
                                      message: "VLER-DAS evaluation submission")
    url = ENV['VLER_DAS_EXAM_RESPONSE_URL']

    if url != nil && url.length > 0
      #validation_errors = evaluation.validate_xml
      req = build_request(url, the_exam_response_string, the_file_name)
      response = HTTPI.post(req)
      activity_log.response_body = response.body
      activity_log.save
    end
  end

  def self.postNotification(notificationXml)
    HTTPI.log       = false
    url = ENV['APP_URL'] + ENV['CLAIMS_API_URL']
    request = HTTPI::Request.new(url)

    request.auth.ssl.verify_mode       = :none

    request.body = notificationXml
    response = HTTPI.post(request)
    responseBody = response.body
  end

  def self.sendNotification(notificationEvent, event_id, claim_id, notification_type)
    if (event_id == nil)
      raise Exception, "Event Id cannot be empty"
    end
    if (claim_id == nil)
      raise Exception, "Claim Id cannot be empty"
    end
    validation_errors = notificationEvent.validate_xml
#    validation_errors = notificationEvent.errors

    url = ENV['VLER_DAS_EXAM_MANAGEMENT_URL']
   if url != nil && url.length > 0
    notificationXml = notificationEvent.to_xml
    notification_log = NotificationLog.new(submitted_xml_data: notificationXml, event_id: event_id, claim_id: claim_id, message: "VLER-DAS notification submission", notification_type: notification_type)
    if validation_errors.empty?
      if notificationXml != nil
        req = build_notification_request(url, notificationXml)

        if VLER_DAS_ENABLE_NOTIFICATIONS
          response = HTTPI.post(req)
          responseBody = response.body

          notification_log.response_body = responseBody
        else
          notification_log.message = "DAS Silver environment seems to having issues. Notification are not being sent to DAS temporarily."
        end
      else
        notification_log.message = "Notification cannot be empty"
      end
    else
      notification_log.message = validation_errors.join("; ")
    end
    notification_log.save
   end
  end

  def self.build_notification_request(url, notificationXml)
    request = HTTPI::Request.new(url)

    request.auth.ssl.verify_mode         = :none

    unless ENV['VLER_DAS_CERT'].blank?
      request.auth.ssl.cert_key_file     = (Rails.root + ENV['VLER_DAS_KEYFILE']).to_s
      request.auth.ssl.cert_file         = (Rails.root + ENV['VLER_DAS_CERT']).to_s
      request.auth.ssl.ca_cert_file      = (Rails.root + ENV['VLER_DAS_CACERT']).to_s
      request.auth.ssl.verify_mode       = :peer
    end

    request.headers = {'Content-Type' => 'application/xml',
                       'Accept'       => 'application/xml'}
    request.body = notificationXml
    request
  end

  # DAS eCRUD ICD section 4.10:
  #
  # Create/POST Request STR PDF Document With Large File Upload Request
  # Request URL Pattern:
  #   POST http(s)://{host}:{port}/ecrud/v1/core/fs
  # ￼￼￼￼￼￼￼￼￼￼￼eCRUD Service Interface Control Document 58 May 2014
  # Required Request Header(s): Content-Type: “multipart/form-data”
  # Required Multipart form requirements in request body:
  # ● “part” is first and only part in multipart request;
  # ● “part” content-type attribute is set, i.e. “application/pdf”;
  # ● “part” is in form element with a name of “file”;
  # ● “part” has original filename stored in above “file” element.
  # Request Payload:
  # Binary stream of application/pdf sent in “multipart/form-data” request. This is usually handled by the eCRUD Consumer, i.e. “User Agent”.
  #
  # RFC 2388:
  # Each part is expected to contain a content-disposition header [RFC 2183] where the
  # disposition type is "form-data", and where the disposition contains
  # an (additional) parameter of "name", where the value of that
  # parameter is the original field name in the form. For example, a part
  # might contain a header:
  #
  # Content-Disposition: form-data; name="user"
  def self.form_encode(data, filename)
    ERB.new(<<-EOF).result(binding)
--3e776445-b95f-4bc7-9dca-38a89dc3a674\r
Content-Disposition: form-data; name="file"; filename="<%= filename %>"\r
Content-Type: application/xml\r
\r
<%= data %>\r
\r
--3e776445-b95f-4bc7-9dca-38a89dc3a674--\r
    EOF
  end

  def self.build_request(url, data, filename)
    request = HTTPI::Request.new(url)

    request.auth.ssl.verify_mode         = :none

    unless ENV['VLER_DAS_CERT'].blank?
      request.auth.ssl.cert_key_file     = (Rails.root + ENV['VLER_DAS_KEYFILE']).to_s
      request.auth.ssl.cert_file         = (Rails.root + ENV['VLER_DAS_CERT']).to_s
      request.auth.ssl.ca_cert_file      = (Rails.root + ENV['VLER_DAS_CACERT']).to_s
      request.auth.ssl.verify_mode       = :peer
    end

    request.headers = {
      'Content-Type' => 'multipart/form-data; boundary=3e776445-b95f-4bc7-9dca-38a89dc3a674',
      'Accept' => 'application/json'
    }
    request.body = form_encode(data, filename)
    request
  end
end
