module XmlHelper
  def self.getDoc(document, tagName)
    if (document != nil)
      doc = document.at('//em:'+tagName, 'em' => 'http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/1.0')
      if (doc == nil)
        # It might be a nonamespace prefix scenario
        doc = document.at(tagName)
      end
      return doc
    end
    return nil
  end

  def self.getAll(document, tagName)
    entries = document.xpath('//em:'+tagName, 'em' => 'http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/1.0')
    return entries
  end

  def self.createTag(document, tagName)
    tag = Nokogiri::XML::Node.new("em:"+tagName, document)
    tag
  end

  def self.getContentType(notificationDoc)
    contentType = ""
    if (notificationDoc != nil && 
        notificationDoc.at('feed/entry/content') != nil && 
        notificationDoc.at('feed/entry/content').first_element_child != nil)
      contentTypeDoc = notificationDoc.at('feed/entry/content').first_element_child

      thirdChild = contentTypeDoc.children[2]

      if (thirdChild != nil)
        tagName = thirdChild.name
        if (["ExamSchedulingRequestCreatedEvent","ContentionCancellationRequestedEvent","AppointmentCancelRequestEvent", "ExamSchedulingRequestCancellationEvent", "RescheduleRequestEvent", "ClarificationResponseEvent", "ReworkedExamSchedulingRequestCreatedEvent"].include? tagName)
          contentType = tagName
        end
      end

      if (contentType == nil or contentType == "")
        sixthChild = contentTypeDoc.children[5]
        if (sixthChild != nil)
          tagName = sixthChild.name
          if (["ExamSchedulingRequestCreatedEvent","ContentionCancellationRequestedEvent","AppointmentCancelRequestEvent", "ExamSchedulingRequestCancellationEvent", "RescheduleRequestEvent", "ClarificationResponseEvent", "ReworkedExamSchedulingRequestCreatedEvent"].include? tagName)
            contentType = tagName
          end
        end
      end

      if (contentType == nil or contentType == "")
        raise Exception, "Invalid Notification Type"
      end
    end
    return contentType
  end

  def self.convertToDocument(xml)
    return Nokogiri::XML(xml)
  end

  def self.getNode(xml,node_name)
    node = XmlHelper.getDoc(XmlHelper.convertToDocument(xml), node_name)
  end
end
