# Helper methods used by stage_exam_requests#create


# Filenames of xml templates that will be used to build final product
EXAM_REQUEST_FILENAME = "ExamRequestTemplate.xml".freeze
CONTENTION_FILENAME = "ContentionTemplate.xml".freeze

# Filename of template user downloads and completes to stage multiple exam requests
XLS_FILENAME = "CUI_Exam_Request_Contentions_Template.xls".freeze


# Absolute paths for files above
EXAM_REQUEST_TEMPLATE_PATH = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', EXAM_REQUEST_FILENAME).freeze
CONTENTION_TEMPLATE_PATH = File.join(Rails.root.to_s, 'lib', 'tasks', 'exam_request', CONTENTION_FILENAME).freeze
XLS_TEMPLATE_PATH = File.join(Rails.root.to_s, 'public', XLS_FILENAME).freeze


# Name of tag used to build contention "nodes" in final xm document
CONTENTIONS_TAG_NAME = "ExamRelatedContentions".freeze

# Get templates off disk and into memory for use
er_file = File.open(EXAM_REQUEST_TEMPLATE_PATH)
ct_file = File.open(CONTENTION_TEMPLATE_PATH)

EXAM_REQUEST_TEMPLATE = er_file.read
CONTENTION_TEMPLATE   = ct_file.read

# Sheet containing the data in the xls file, other sheets contain instructions etc
XLS_SHEET_CONTAINING_DATA = 1

# Columns indices for fields
FIRST_NAME_COL            = 0
LAST_NAME_COL             = 1
FILE_NUM_COL              = 2
CLAIM_ID_COL              = 3
SITE_COL                  = 4
CONTENTION_COL            = 5

# array of values that cause a row to be ignored
IGNORE_LIST = ["(Example"].freeze


module StageExamRequestsHelper

 require 'spreadsheet'

 def self.createExamRequestXml(form_hash)
  exam_request_xml = self.xmlExamRequestBuilderFromForm(form_hash)
  er_doc = XmlHelper.convertToDocument(exam_request_xml)
  claimId = form_hash[:claim_id]
  contentions = form_hash[:contentions]
  er_contentions_doc = XmlHelper.getDoc(er_doc, "ExamRelatedContentions")
  contentions.each do |key, contention_name|
   contention_str = self.xmlContentionsBuilderFromForm(contention_name, claimId)
   node = Nokogiri::XML.fragment(contention_str)
   er_contentions_doc << node.children
  end

  er_doc.to_xml

 end

 def self.xmlContentionsBuilderFromForm(contention_name, claimId)
  contention = CONTENTION_TEMPLATE.clone
  contention.gsub! '###CONTENTION_ID###', Array.new(36){rand(36).to_s(36)}.join
  contention.gsub! '###CONTENTION_NAME###', contention_name
  contention.gsub! '###CLAIM_ID###', claimId
  contention
 end



 def self.xmlExamRequestBuilderFromForm(form_hash)
  er_contents = EXAM_REQUEST_TEMPLATE.clone
  er_contents.gsub! '###FIRST_NAME###',  form_hash[:first_name]
  er_contents.gsub! '###LAST_NAME###',   form_hash[:last_name]
  er_contents.gsub! '###FILE_NUMBER###', form_hash[:file_number]
  er_contents.gsub! '###CLAIM_ID###',    form_hash[:claim_id]
  er_contents.gsub! '###SITE###',        form_hash[:site]
  er_contents


 end


 def self.createExamRequestsFromXls(xls_file)

  # stores valid exam requests for posting as XML
  xls_array = []

  #setup logger
  log = ActiveSupport::Logger.new("log/#{xls_file.split("/").last}.log")
  log.info "--Starting @ #{Time.now.strftime('%H:%M:%S')}"

  # open the file and goto the correct worksheet and begin crawling each row
  book    = Spreadsheet.open xls_file
  sheet1  = book.worksheet XLS_SHEET_CONTAINING_DATA

  sheet1.each_with_index do |row, row_indx|
    # Index 0 (Column A): First Name               (mandatory)
    # Index 1 (Column B): Last Name                (mandatory)
    # Index 2 (Column C): File Number              (mandatory)
    # Index 3 (Column D): Claim ID                 (mandatory)
    # Index 4 (Column E): Site                     (mandatory)
    # Index 5 (Column F): Contention(s)            (mandatory)


   next if row_indx == 0  # skip first row, which should contain column labels
   log.info "Processing #{row[FIRST_NAME_COL]} - #{row[LAST_NAME_COL]} ..."

   # process each row in the xls file according to its type
   case xls_row_type(row)
    when :new_exam_request_with_contention # create new hash and push onto xls_array

      row_hash={first_name:  row[FIRST_NAME_COL].to_s,
                last_name:   row[LAST_NAME_COL].to_s,
                file_number: row[FILE_NUM_COL].to_s,
                claim_id:    row[CLAIM_ID_COL].to_s,
                site:        row[SITE_COL].to_s,
                contentions:  {"0"=> row[CONTENTION_COL].to_s}} # NOTE: contentions are a nested *hash* inside exam requests with *string* keys, NOT symbol keys, note the '=>'

      xls_array.push(row_hash)
      log.info "----Added #{row[FIRST_NAME_COL].to_s+" "+row[LAST_NAME_COL].to_s} to array"

    when :new_exam_request_without_contention
      log.info "----Skipped #{row[FIRST_NAME_COL].to_s+" "+row[LAST_NAME_COL].to_s} because no contentions found"
      next

    when :new_contention_row # find last-added element in the xls_array and append new contention to nested hash in it
      begin
        new_subkey = xls_array.last[:contentions].keys.last.to_s.to_i+1
        xls_array.last[:contentions][new_subkey.to_s]=row[CONTENTION_COL].to_s
        log.info "----Added contention #{row[CONTENTION_COL]} to hash for #{xls_array.last[:first_name]+" "+xls_array.last[:last_name]}"
      rescue NoMethodError
        next
      end
    when :ignore_row
      next
    else
      next
    end  # end of case block

  end  # end of sheet iterator

  #
  xls_array.each do |row|
     er_xml=StageExamRequestsHelper.createExamRequestXml(row)
     PostXmlToEndpoint.set(wait: 1.seconds).perform_later(er_xml)
     log.info "----Posted XML for #{row[:first_name]+" "+row[:last_name]}"
  end

  log.info "--Stopping @ #{Time.now.strftime('%H:%M:%S')}\n"

 end  # end of createExamRequestFromXls

 # determine and return row type to direct processing
 def xls_row_type(xls_row)
  if xls_row[FIRST_NAME_COL].to_s.start_with?(*IGNORE_LIST)
   return :ignore_row  # ignore row if it starts with words in our IGNORE_LIST

  elsif [FIRST_NAME_COL, LAST_NAME_COL, FILE_NUM_COL,CLAIM_ID_COL,SITE_COL,CONTENTION_COL].all? {|col_indx| !xls_row[col_indx].blank? }
   return :new_exam_request_with_contention  # if all columns have values than we have a new exam request with contention

  elsif [FIRST_NAME_COL, LAST_NAME_COL, FILE_NUM_COL,CLAIM_ID_COL,SITE_COL].all? {|col_indx| !xls_row[col_indx].blank? } && xls_row[CONTENTION_COL].blank?
   return :new_exam_request_without_contention # if all columns except CONTENTION_COL are full we have a new exam request without contention

  elsif [FIRST_NAME_COL, LAST_NAME_COL, FILE_NUM_COL,CLAIM_ID_COL,SITE_COL].all? {|col_indx| xls_row[col_indx].blank? } && !xls_row[CONTENTION_COL].blank?
   return :new_contention_row  # if all columns except CONTENTION_COL are blank we have a new contention to add to the previously seen exam request

  else return :ignore_row
  end

 end


#END OF MODULE
end

