module RequestObjectHelper
  def addClarificationRequestEventToRequestObject(clarificationEventEventNotificationDoc, claimId)
    requestObject = getRequestObject(claimId)
    xml = requestObject.xml
    requestObjectDoc = XmlHelper.convertToDocument(xml)
    
    requestScopeEventsDoc = XmlHelper.getDoc(requestObjectDoc, "RequestScopeEvents")

    clarificationRequestEventDoc = XmlHelper.getDoc(clarificationEventEventNotificationDoc.document.root, "ClarificationRequestEvent")
    requestScopeEventsDoc << clarificationRequestEventDoc

    examSchedulingRequestDoc = XmlHelper.getDoc(requestObjectDoc, "ExamSchedulingRequest")
    saveRequestObject(examSchedulingRequestDoc['eventId'], claimId, requestObjectDoc.to_xml)
  end

  def addClarificationResponseEventToRequestObject(clarificationResponseEvent, claimId)
    requestObject = getRequestObject(claimId)
    xml = requestObject.xml
    requestObjectDoc = XmlHelper.convertToDocument(xml)

    requestScopeEventsDoc = XmlHelper.getDoc(requestObjectDoc, "RequestScopeEvents")

    requestScopeEventsDoc << clarificationResponseEvent

    saveRequestObject(clarificationResponseEvent['eventId'], claimId, requestObjectDoc.to_xml)
  end

  def handleExamSchedulingRequestCancellationEvent(examSchedulingRequestCancellationEvent, examRequest, requestObject)
    xml = requestObject.xml
    requestObjectDoc = XmlHelper.convertToDocument(xml)
    requestScopeEventsDoc = XmlHelper.getDoc(requestObjectDoc, "RequestScopeEvents")
    requestScopeEventsDoc  << examSchedulingRequestCancellationEvent

    saveRequestObject(examSchedulingRequestCancellationEvent['eventId'], examRequest.claim_id, requestObjectDoc.to_xml)
  end

  def getRequestObject(claim_id)
    return RequestObject.all.order('created_at desc').find_by_claim_id(claim_id)
  end

  def getRequestObjectByEventId(eventId)
    return RequestObject.all.order('created_at desc').find_by_event_id eventId
  end

  def saveRequestObject(eventId, claimId, xml)
    reqObject = RequestObject.all.order('created_at desc').find_by_claim_id claimId
    if reqObject.present?
      reqObject.update(active: false)
      reqObject.save
    end
    reqObject = RequestObject.create(request_type: "ClarificationRequestEvent_Notification", event_id: eventId, claim_id: claimId, active: true, xml: xml)
  end
end
