module ReferralsHelper
  include ApplicationHelper

  def get_tab_class(tab)
    active_tab?(tab) ? "selected usa-current" : "unselected"
  end

  def get_tabpage_style(tab)
    active_tab?(tab) ? "display:block" : "display:none"
  end

  # Return count contained in hash[attribute][:count], if present.
  # If attribute of :count keys don't exist, then return zero instead of
  # throwing an error.
  def get_status_count(hash, attribute)
    if hash.has_key?(attribute)
      return hash[attribute].try(:[], :count) || 0
    end
    return 0
  end

private

  def active_tab?(tab)
    if current_user.is_vha_cc?
      active_tab = params['tabpage'] || ReferralsController::DEFAULT_REFERRAL_TAB
      (tab == active_tab)
    elsif current_user.is_non_vha?
      active_tab = params['tabpage'] || "documents"
      (tab == active_tab)
    end
  end

end
