module ContentionObjectHelper
  def addOrUpdateContentionObject(exam_related_contention, examSchedulingRequestCreatedEventEntry)
    path = File.join(Rails.root.to_s, 'app', 'xml', 'exam_management', 'contention_object.xml')
    document = Nokogiri::XML(File.open(path))
    
    document << exam_related_contention

    addContentionScopeEvents(document, exam_related_contention, examSchedulingRequestCreatedEventEntry)

  end

  def addContentionScopeEvents(document, contention, examSchedulingRequestCreatedEventEntry)
    contentionScopeEventsTag = XmlHelper.createTag(document, "ContentionScopeEvents")

    resultPackageAvailableEventTag = XmlHelper.createTag(document, "ResultPackageAvailableEvent")

    resultPackageAvailableEventTag.set_attribute("eventId", examSchedulingRequestCreatedEventEntry.attributes["eventId"].value)
    resultPackageAvailableEventTag.set_attribute("eventDtg", examSchedulingRequestCreatedEventEntry.attributes["eventDtg"].value)
    resultPackageAvailableEventTag.set_attribute("modelVersion", examSchedulingRequestCreatedEventEntry.attributes["modelVersion"].value)
    resultPackageAvailableEventTag.set_attribute("examRelatedContentionId", contention["examRelatedContentionId"])

    eventSourceEntry = XmlHelper.getDoc(examSchedulingRequestCreatedEventEntry, 'EventSource')
    
    resultPackageAvailableEventTag << eventSourceEntry.clone
    documentReferenceTag = XmlHelper.createTag(document, "documentReference")

    #FIX ME: Need to get the right value
    documentReferenceTag.content = "24b3309b-5d5a-4ea6-b335-5248b0c4e244"

    #Add documentReferenceTag to resultPackageAvailableEventTag
    resultPackageAvailableEventTag << documentReferenceTag

    # Add resultPackageAvailableEventTag to contentionScopeEventsTag
    contentionScopeEventsTag << resultPackageAvailableEventTag

    #Add contentionScopeEventsTag to the main document
    document.root << contentionScopeEventsTag

    #Save the contention object
    save(contention["examRelatedContentionId"], document.to_xml)

    #examRelatedContentionId = contention["examRelatedContentionId"]
    #contentionObject = ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionId
    #if contentionObject.present?
    #  contentionObject.update(active: false)
    #  contentionObject.save
    #end
    #ContentionObject.create(exam_related_contention_id: contention["examRelatedContentionId"], xml: document.to_xml, active: true) 
  end

  def handleContentionCancellationRequestedEvent(notificationDoc, contention)
    contentionCancellationRequestedEvent = XmlHelper.getDoc(notificationDoc, "ContentionCancellationRequestedEvent")
    contentionObject = getContentionObject(contention.exam_related_contention_id)
    
    xml = contentionObject.xml
    contentionDoc = XmlHelper.convertToDocument(xml)
    contentionScopeEventsDoc = XmlHelper.getDoc(contentionDoc, "ContentionScopeEvents")
   
    contentionScopeEventsDoc << contentionCancellationRequestedEvent
 
    save(contention.exam_related_contention_id, contentionDoc.to_xml)
  end

  def handleContentionCancelledEvent(contentionCanceledEventDoc, contention)
    contentionObject = getContentionObject(contention.exam_related_contention_id)
    xml = contentionObject.xml
    contentionDoc = XmlHelper.convertToDocument(xml)
 
    contentionScopeEventsDoc = XmlHelper.getDoc(contentionDoc, "ContentionScopeEvents")

    contentionScopeEventsDoc << contentionCanceledEventDoc

    save(contention.exam_related_contention_id, contentionDoc.to_xml)
  end
  
  def getContentionObject(examRelatedContentionId)
    return ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionId
  end
  
  private
  
  def save(examRelatedContentionId, xml)
    contentionObject = ContentionObject.all.order('created_at desc').find_by_exam_related_contention_id examRelatedContentionId
    if contentionObject.present?
      contentionObject.update(active: false)
      contentionObject.save
    end
    ContentionObject.create(exam_related_contention_id: examRelatedContentionId, xml: xml, active: true)
  end
end
