module AppointmentHelper
  include AppointmentObjectHelper, ContentionHelper


  def display_date_value(params, element)
    params[:dates].nil? ? nil : params[:dates][element]
  end

  def processRescheduleRequestEvent(notificationDoc)
    ActiveRecord::Base.transaction do
      rescheduleRequestEvent = XmlHelper.getDoc(notificationDoc, "RescheduleRequestEvent")
      previousEvent = rescheduleRequestEvent['previousEvent']
      examAppointmentId = rescheduleRequestEvent['examAppointmentId']

      appointmentObjectFromDb = getAppointmentObject(examAppointmentId)
      if (isValidAppointmentObject(appointmentObjectFromDb) )
        rescheduleApppointment(notificationDoc, appointmentObjectFromDb)

        updateAppointmentObjectWithRescheduleEvent(notificationDoc, appointmentObjectFromDb)
      end
    end
  end

  def rescheduleApppointment(rescheduleRequestEvent, appointmentObjectFromDb)
    examination = Examination.find_by_identifier appointmentObjectFromDb.examination_identifier
    examStateReschedule = ExaminationState.find_by_code("RESCHEDULE")
    examination.examination_state_id = examStateReschedule.id
    examination.save

    #get the examination_schedule record
    details =  XmlHelper.getDoc(rescheduleRequestEvent, "Details")
    examinationSchedule = ExaminationSchedule.find_by_examination_id(examination.id)
    examinationSchedule.reschedule_reason = details.text
    examinationSchedule.save
  end

  def processAppointmentCancelRequestEvent(notificationDoc)
   ActiveRecord::Base.transaction do
    appointmentCancelRequestEvent = XmlHelper.getDoc(notificationDoc, "AppointmentCancelRequestEvent")

    examAppointmentId = appointmentCancelRequestEvent['examAppointmentId']

    appointmentObjectFromDb = getAppointmentObject(examAppointmentId)
    if (isValidAppointmentObject(appointmentObjectFromDb) )
      #Cancelling appointment is same as Cancelling Examination
      cancelAppointment(examAppointmentId, appointmentCancelRequestEvent, appointmentObjectFromDb)

      updateAppointmentObjectWithAppointmentCancelEvent(notificationDoc, appointmentObjectFromDb)

      examination = Examination.find_by_identifier appointmentObjectFromDb.examination_identifier

      appointmentCanceledEvent = AppointmentCanceledEvent.new
      eventId = appointmentCanceledEvent.build_notification(examAppointmentId)
      VlerDASJob.sendNotification(appointmentCanceledEvent, eventId, examination.claim_id, "Appointment Cancelled Event Notification")

      updateAppointmentObjectWithAppointmentCancelledEvent(appointmentCanceledEvent.document, appointmentObjectFromDb)
    end
   end
  end

  def sendAppointmentCancelledEvent(appointmentObject, previousEventId)
    exam_request = ExamRequest.find_by_claim_id(contention.claim_id)
    contentionCancelledEventNotification = ContentionCancelledEventNotification.new
    eventId = contentionCancelledEventNotification.build_notification(contention, exam_request.site_id, previousEventId)
    VlerDASJob.sendNotification(contentionCancelledEventNotification, eventId, contention.claim_id, "Contention Cancelled Event Notification")
  end

  private

  def updateAppointmentObjectWithAppointmentCancelEvent(notificationDoc, appointmentObjectFromDb)
    handleAppointmentCancelRequestEvent(notificationDoc, appointmentObjectFromDb)
  end

  def updateAppointmentObjectWithAppointmentCancelledEvent(notificationDoc, appointmentObjectFromDb)
    handleAppointmentCancelledEvent(notificationDoc, appointmentObjectFromDb)
  end

  def isValidAppointmentObject(appointmentObjectFromDb)
    validRequest = true
    if (appointmentObjectFromDb == nil)
      validRequest = false
      raise Exception, "Invalid Exam Appointment Id"
    end
    return validRequest
  end

  def cancelAppointment(examAppointmentId, appointmentCancelRequestEvent, appointmentObjectFromDb)
    examination_identifier = appointmentObjectFromDb.examination_identifier
    if (examination_identifier == nil)
      raise Exception, "Invalid Appointment Cancel Request. Cannot find a corresponding examination."
    end

    examination = Examination.find_by_identifier(examination_identifier)

    if (examination == nil)
      raise Exception, "Invalid Appointment Cancel Request. Cannot find a corresponding examination."
    end

    examStatePendingCancellation = ExaminationState.find_by_code("CANCELLED")
    examination.examination_state_id = examStatePendingCancellation.id
    cancellationReasonTag = XmlHelper.getDoc(appointmentCancelRequestEvent, "Details")
    if (cancellationReasonTag == nil)
      raise Exception, "Missing appointment cancellation reason (Details tag)"
    end

    examination.cancellation_reason = cancellationReasonTag.content
    examination.save

    examRequest = ExamRequest.find_by_id(examination.exam_request_id)
    notes = "Examination "
    notes = notes + "(" + appendContentionNames(examination.contentions) + ") has been cancelled"
    @@exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @@exam_request_history.save
  end


end
