XLS_UPLOAD_PATH = "/public/uploads/StageExamRequests".freeze
include StageExamRequestsHelper

VALID_MIME_TYPE="application/vnd.ms-excel".freeze


class StageExamRequestsController < ApplicationController

  before_action :set_stage_exam_request, only: [:edit, :update, :destroy]

  # GET /stage_exam_requests/new
  def new
  end

  # POST /stage_exam_requests
  # POST /stage_exam_requests.json
  def create

    case params[:commit]
      when "Submit"
        #Process single ER+Contentions from form hash
        er_xml=StageExamRequestsHelper::createExamRequestXml(params[:single_exam_request])
        #post the data
        if PostXmlToEndpoint.set(wait: 1.seconds).perform_later(er_xml)
          flash.now[:notice] = "Exam Request staged!"
        else
          flash.now[:alert] = "Exam Request could not be staged!"
        end
        render 'new'

      when "Upload"
        if params[:batch_exam_requests].present? && params[:batch_exam_requests][:excel_file].content_type == VALID_MIME_TYPE
          unprocessed_xls = upload
          flash.now[:notice] = "File upload successful, processing to begin shortly!"
          StageExamRequestsHelper::createExamRequestsFromXls(unprocessed_xls)

          # Delete the file
          File.delete(unprocessed_xls)

          render 'new'

        else
          flash.now[:alert] = "Please select a valid .xls file using the Choose File button before clicking Upload!"
          render 'new'
        end
      end
    end

  # upload xls for staging multiple ER's with contentions
  def upload
      uploaded_io = params[:batch_exam_requests][:excel_file]
      old_file_name = Rails.root.join('public', 'uploads','StageExamRequests', uploaded_io.original_filename).to_s
      new_file_name = old_file_name + ".#{Array.new(6){rand(36).to_s(36)}.join}"
      File.open(Rails.root.join('public', 'uploads','StageExamRequests', uploaded_io.original_filename), 'wb') do |file|
        file.write(uploaded_io.read)
      end
      File.rename(old_file_name, new_file_name)
      return new_file_name
  end

  def download_excel_template
      send_file(
        XLS_TEMPLATE_PATH,
        filename: XLS_FILENAME,
        disposition: "attachment",
        type: "application/xls",
        x_sendfile: true
      ) and return
  end

end
