class NotificationLogsController < ApplicationController
  before_action :set_notification_log, only: [:show, :edit, :update, :destroy]

  # GET /notification_logs
  # GET /notification_logs.json
  def index
    @notification_logs = NotificationLog.all
  end

  # GET /notification_logs/1
  # GET /notification_logs/1.json
  def show
    @notification_log = NotificationLog.find_by_id(params[:id])
  end

  # GET /notification_logs/new
  def new
    @notification_log = NotificationLog.new
  end

  # GET /notification_logs/1/edit
  def edit
  end

  # POST /notification_logs
  # POST /notification_logs.json
  def create
    @notification_log = NotificationLog.new(notification_log_params)

    respond_to do |format|
      if @notification_log.save
        format.html { redirect_to @notification_log, notice: 'Notification log was successfully created.' }
        format.json { render action: 'show', status: :created, location: @notification_log }
      else
        format.html { render action: 'new' }
        format.json { render json: @notification_log.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /notification_logs/1
  # PATCH/PUT /notification_logs/1.json
  def update
    respond_to do |format|
      if @notification_log.update(notification_log_params)
        format.html { redirect_to @notification_log, notice: 'Notification log was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @notification_log.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /notification_logs/1
  # DELETE /notification_logs/1.json
  def destroy
    @notification_log.destroy
    respond_to do |format|
      format.html { redirect_to notification_logs_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_notification_log
      @notification_log = NotificationLog.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def notification_log_params
      params[:notification_log]
    end
end
