class ExaminationNotesController < ApplicationController
  before_action :set_examination_note, only: [:show, :edit, :update, :destroy]

  # GET /examination_notes
  # GET /examination_notes.json
  def index
    @examination_notes = ExaminationNote.all
  end

  # GET /examination_notes/1
  # GET /examination_notes/1.json
  def show
  end

  # GET /examination_notes/new
  def new
    @examination_note = ExaminationNote.new
  end

  # GET /examination_notes/1/edit
  def edit
  end

  # POST /examination_notes
  # POST /examination_notes.json
  def create
    @examination_note = ExaminationNote.new(examination_note_params)

    respond_to do |format|
      if @examination_note.save
        format.html { redirect_to @examination_note, notice: 'Examination note was successfully created.' }
        format.json { render action: 'show', status: :created, location: @examination_note }
      else
        format.html { render action: 'new' }
        format.json { render json: @examination_note.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /examination_notes/1
  # PATCH/PUT /examination_notes/1.json
  def update
    respond_to do |format|
      if @examination_note.update(examination_note_params)
        format.html { redirect_to @examination_note, notice: 'Examination note was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @examination_note.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /examination_notes/1
  # DELETE /examination_notes/1.json
  def destroy
    @examination_note.destroy
    respond_to do |format|
      format.html { redirect_to examination_notes_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_examination_note
      @examination_note = ExaminationNote.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def examination_note_params
      params.require(:examination_note).permit(:from_id, :to_id, :note, :type)
    end
end
