class EvaluationTemplatesController < ApplicationController
  before_action :set_evaluation_template, only: [:show, :update, :destroy, :sort]
  include DataTablePaginator
  check_authorization
  authorize_resource

  # GET /evaluation_templates
  # GET /evaluation_templates.json
  def index
    ev_templates_to_fields_func = -> (ev) do
      {
        id:                       ev.id,
        name:                     ev.name.try(:humanize),
        edit:                     edit_evaluation_template_path(ev),
        destroy:                  evaluation_template_path(ev)
      }
    end
    ordered_ev_templates = EvaluationTemplate.all.order('id asc')
    @return_data = datatables_json_for_query_using_func(
      ordered_ev_templates, ev_templates_to_fields_func
    ).to_json
  end

  # GET /evaluation_templates/1
  # GET /evaluation_templates/1.json
  def show
  end

  # GET /evaluation_templates/new
  def new
    @evaluation_template = EvaluationTemplate.new
  end

  # GET /evaluation_templates/1/edit
  def edit
    @evaluation_template = EvaluationTemplate.includes(:major_systems)
                                             .find(params[:id])
    if params[:delete_major_system_id].present?
      maj = @evaluation_template.major_systems.find_by_id(params[:delete_major_system_id])
      @evaluation_template.major_systems = @evaluation_template.major_systems.reject{|m| m == maj}
      flash.now[:notice] = "Major System successfully removed."
    elsif params[:cf].present?
      @html_repository = @evaluation_template.load_html_repository
      flash.now[:notice] = "HTML successfully loaded to repository."
    end
    @major_systems_not_yet_added = MajorSystem.order_by_position_asc
    @evaluation_template.major_systems.order("position ASC").each do |ms|
      @major_systems_not_yet_added = @major_systems_not_yet_added.reject{|m| m == ms}
    end
    # @generated_html = @evaluation_template.build_html
  end

  def generated_html
    @eval_template = EvaluationTemplate.includes(:major_systems)
                                       .find(params[:evaluation_template_id])
    @generated_html = @eval_template.build_html

    render partial: 'displayed_result'
  end

  # POST /evaluation_templates
  # POST /evaluation_templates.json
  def create
    @evaluation_template = EvaluationTemplate.new(evaluation_template_params)

    respond_to do |format|
      if @evaluation_template.save
        format.html { redirect_to @evaluation_template, notice: 'Evaluation template was successfully created.' }
        format.json { render action: 'show', status: :created, location: @evaluation_template }
      else
        format.html { render action: 'new' }
        format.json { render json: @evaluation_template.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /evaluation_templates/1
  # PATCH/PUT /evaluation_templates/1.json
  def update
    respond_to do |format|
      if @evaluation_template.update(evaluation_template_params)
        if params[:evaluation_template] && params[:evaluation_template][:major_system_ids]
          params[:evaluation_template][:major_system_ids].each do |m|
            major_system = MajorSystem.find_by_id(m)
            if major_system
              @evaluation_template.major_systems << major_system
            end
          end
        end
        @evaluation_template.save
        format.html { redirect_to edit_evaluation_template_path(@evaluation_template), notice: 'Evaluation template successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @evaluation_template.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /evaluation_templates/1
  # DELETE /evaluation_templates/1.json
  def destroy
    @evaluation_template.destroy
    respond_to do |format|
      format.html { redirect_to evaluation_templates_url }
      format.json { head :no_content }
    end
  end

  def sort
    params[:major_system].each_with_index do |id, index|
      @evaluation_template.major_systems.where(id: id).update_all({position: index+1})
    end
    render nothing: true
  end

  def paged_list
    ev_templates_to_fields_func = -> (ev) do
      {
        id:                       ev.id,
        name:                     ev.name.try(:humanize),
        edit:                     edit_evaluation_template_path(ev),
        destroy:                  evaluation_template_path(ev)
      }
    end
    ordered_ev_templates = apply_ordering_to_query(EvaluationTemplate.filter(params), EvaluationTemplate::FIELDS_FOR_RESULTSET, params['order'])
    return_data = datatables_json_for_query_using_func(ordered_ev_templates, ev_templates_to_fields_func)

    render json: return_data
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_evaluation_template
      @evaluation_template = EvaluationTemplate.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def evaluation_template_params
      params.require(:evaluation_template).permit(:name, :label)
    end
end
