class DbqInformationsController < ApplicationController
	include DataTablePaginator
	before_action :set_dbq_information, only: [:show, :edit, :update, :destroy, :sort,
									:general_questions_sort, :diagnoses_sort, :symptoms_sort]

	def index
    dbq_info_func = -> (dbq) do
    	{
        id:                       dbq.id,
        title:                    dbq.title,
        identifier:               dbq.identifier,
        edit:                     edit_dbq_information_path(dbq),
        destroy:                  dbq_information_path(dbq)
      }
    end

    ordered_dbq = DbqInformation.all.order('title asc')
    @return_data = datatables_json_for_query_using_func(
      	ordered_dbq, dbq_info_func
    	).to_json
	end

	def show

	end

	def edit
    if params[:delete_contention_id].present?
      min = @dbq_information.contentions.find_by_id(params[:delete_contention_id])
      @dbq_information.contentions = @dbq_information.contentions.reject{|m| m == min}
      flash.now[:notice] = "Contention successfully removed."
    elsif params[:delete_symptom_id].present?
      min = @dbq_information.symptoms.find_by_id(params[:delete_symptom_id])
      @dbq_information.symptoms = @dbq_information.symptoms.reject{|m| m == min}
      flash.now[:notice] = "Symptom successfully removed."
    elsif params[:delete_general_question_id].present?
      min = @dbq_information.general_questions.find_by_id(params[:delete_general_question_id])
      @dbq_information.general_questions = @dbq_information.general_questions.reject{|m| m == min}
      flash.now[:notice] = "General Question successfully removed."
    elsif params[:delete_diagnosis_id].present?
      min = @dbq_information.diagnoses.find_by_id(params[:delete_diagnosis_id])
      @dbq_information.diagnoses = @dbq_information.diagnoses.reject{|m| m == min}
      flash.now[:notice] = "Diagnosis successfully removed."
    end

    set_dbq_informations_not_added @dbq_information
    set_symptoms_not_added @dbq_information
    set_diagnosis_not_added @dbq_information
    set_general_question_not_added @dbq_information

	end

	def update
		 respond_to do |format|
      if @dbq_information.update(dbq_information_params)
        if params[:dbq_information] && params[:dbq_information][:contention_ids]
          params[:dbq_information][:contention_ids].reject(&:empty?).each do |id|
            contention = Contention.find_by_id(id)
            if contention
              @dbq_information.contentions << contention
            end
          end
        end
        if params[:dbq_information] && params[:dbq_information][:symptom_ids]
          params[:dbq_information][:symptom_ids].reject(&:empty?).each do |id|
            symptom = Symptom.find_by_id(id)
            if symptom
              @dbq_information.symptoms << symptom
            end
          end
        end
        if params[:dbq_information] && params[:dbq_information][:diagnosis_ids]
          params[:dbq_information][:diagnosis_ids].reject(&:empty?).each do |id|
            diagnosis = Diagnosis.find_by_id(id)
            if diagnosis
              @dbq_information.diagnoses << diagnosis
            end
          end
        end
        if params[:dbq_information] && params[:dbq_information][:general_question_ids]
          params[:dbq_information][:general_question_ids].reject(&:empty?).each do |id|
            general_question = GeneralQuestion.find_by_id(id)
            if general_question
              @dbq_information.general_questions << general_question
            end
          end
        end
        @dbq_information.save
        format.html { redirect_to edit_dbq_information_path(@dbq_information), notice: 'DBQ Information successfully updated.' }
        format.json { head :no_content }
      else
        #set_minor_systems_not_yet_added @dbq_information
        #@generated_html = @dbq_information.build_html
        format.html { render action: 'edit' }
        format.json { render json: @dbq_information.errors, status: :unprocessable_entity }
      end
    end

	end

	def destroy
		@dbq_information.destroy
    respond_to do |format|
      format.html { redirect_to dbq_information_url }
      format.json { head :no_content }
    end
	end

	def new
		@dbq_information = DbqInformation.new
	end

	def create
		@dbq_information = DbqInformation.new(dbq_information_params)

    respond_to do |format|
      if @dbq_information.save
        format.html { redirect_to edit_dbq_information_path(@dbq_information), notice: 'DBQ Information was successfully created.' }
      else
        format.html { render action: 'new', notice: 'Issue savinge DBQ Information.' }
      end
    end
	end

	def sort
    params[:contention].each_with_index do |id, index|
      @dbq_information.contentions_dbq_informations
      	.where(contention_id: id)
      	.update_all({position: index+1})
    end
    render nothing: true
  end

  def diagnoses_sort
  	params[:diagnosis].each_with_index do |id, index|
      @dbq_information.diagnoses_dbq_informations
      	.where(diagnosis_id: id)
      	.update_all({position: index+1})
    end
    render nothing: true
  end

  def symptoms_sort
  	params[:symptom].each_with_index do |id, index|
      @dbq_information.symptoms_dbq_informations
      	.where(symptom_id: id)
      	.update_all({position: index+1})
    end
    render nothing: true
  end

  def general_questions_sort
  	params[:general_question].each_with_index do |id, index|
      @dbq_information.general_questions_dbq_informations
      	.where(general_question_id: id)
      	.update_all({position: index+1})
    end
    render nothing: true
  end

  private
		def set_dbq_information
			@dbq_information = DbqInformation.find(params[:id])
		end

		def dbq_information_params
	    params.require(:dbq_information).permit(:title, :identifier, :contention_ids,
	    	:symptom_ids, :diagnosis_ids, :general_question_ids)
	  end

		def set_dbq_informations_not_added info
		  @dbq_info_not_yet_added = Contention.all.order("name ASC")
	    info.contentions.each do |con|
	      @dbq_info_not_yet_added = @dbq_info_not_yet_added.reject{|i| i == con}
	    end
	  end

	  def set_symptoms_not_added info
		  @sym_not_yet_added = Symptom.all.order("name ASC")
	    info.symptoms.each do |sym|
	      @sym_not_yet_added = @sym_not_yet_added.reject{|i| i == sym}
	    end
	  end

	  def set_diagnosis_not_added info
		  @diag_not_yet_added = Diagnosis.all.order("name ASC")
	    info.diagnoses.each do |dia|
	      @diag_not_yet_added = @diag_not_yet_added.reject{|i| i == dia}
	    end
	  end

	  def set_general_question_not_added info
		  @gq_not_yet_added = GeneralQuestion.all.order("name ASC")
	    info.general_questions.each do |q|
	      @gq_not_yet_added = @gq_not_yet_added.reject{|i| i == q}
	    end
	  end

end