#
# The controller class to handle the SAML Request and Response for VA SSOi functionality
#
class CuiSamlController < ApplicationController

  require 'saml_settings'

  skip_before_filter :verify_authenticity_token

  #
  # Method to construct a request and redirect the user to the SSOi Target Endpoint
  #
  def cui_ssoi
    saml_auth_request = OneLogin::RubySaml::Authrequest.new
    saml_settings = SAML::SettingsService.cui_saml_settings
    redirect_to saml_auth_request.create(saml_settings)
  end

  #
  # Method to handle the SAML response that comes back from the SSOi Target Endpoint
  # Based on the attributes, user will be redirected accordingly
  #
  def cui_callback
    saml_response = OneLogin::RubySaml::Response.new(params[:SAMLResponse], settings: SAML::SettingsService.cui_saml_settings)
    response_attrs = saml_response.attributes
    if saml_response.is_valid?(true)
      user = User.from_omniauth(saml_response.attributes)
      if user.present?
        Rails.logger.info("User successfully logged in via SSOi callback.  Attributes = #{user.attributes.inspect}")
        sign_in_and_redirect user
      else
        msg = "SSOi user #{saml_response.attributes['email']} does not have a valid CUI system account. " +
              "Contact the system admin for further assistance."
        Rails.logger.error msg
        flash[:alert] = msg
        redirect_to new_user_session_path
      end
    else
      Rails.logger.error "Invalid SAML response.  Errors: #{saml_response.errors.inspect}"
      flash[:alert] = saml_response.errors
      redirect_to new_user_session_path
    end
  end
end
