//= require dataTables/jquery.dataTables
$('#vhaUserData').DataTable({
    bLengthChange: false,
    aaSorting: [[4, 'asc']],
    aoColumnDefs: [
    { width: 81, targets: [2,3] }],
    bSort: true,
    bFilter: false
}
);


$(document).ready(function() {
  var table = $('#vhaUserData').DataTable();
  $('#vhaUserData tbody').on('click', 'tr', function () {
    var data = table.row( this ).data();
    window.location = "referrals/"+$(this).attr('id');
  });

  var $childReferralTable = $('#vhaUserConsData').DataTable({
      bLengthChange: false,
      aaSorting: [[4, 'asc']],
      bSort: true,
      bFilter: false,
      pageLength: 5,
      columns: [
        {data: 'referral_type'},
        {data: 'authorization_number'},
        {data: 'provider_name'},
        {data: 'NPI'},
        {data: 'date'},
        {data: 'referral_status'}
      ]
  });

  $('form.new_referral').submit(function(e) {
      var valuesToSubmit = $(this).serialize();
      e.preventDefault();  // prevents normal behaviour
      $.ajax({
          type: "POST",
          url: $(this).attr('action'), //sumbits it to the given url of the form
          data: valuesToSubmit,
          dataType: "JSON" // you want a difference between normal and ajax-calls, and json is standard
      }).done(function(json) {
        $('.alerts.alert-box').remove();
        $('#header').after('<div class="alerts alert-box success animated bounceInLeft" id="referral-added"> <div class="row"> <div class="small-12 columns">'+json.message+'</div> </div> </div>');
        window.scrollTo(0,0);
        var x = parseInt($('#authorization_number').val());
        $('#authorization_number').val(x);
        // Add new data and redraw the DataTable
        $childReferralTable.row.add(json.data).draw();
        $childReferralTable.columns.adjust().draw();
        // add id to newly created referral table row
        var row_index = $('#vhaUserConsData').dataTable().fnGetNodes().length - 1;
        var row = $('#vhaUserConsData').dataTable().fnGetNodes(row_index);
        $(row).attr('id', json.id);
      }).fail(function(jqXHR) {
        $('#invalid-ssn').remove();
        $('#referral-added').remove();
        $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid-ssn"> <div class="row"> <div class="small-12 columns"><span>'+JSON.parse(jqXHR.responseText).error+'</div> </div> </div>');
        window.scrollTo(0,0);
      });
      return false;
  });

  $('#vhaUserConsData tbody').on('click', 'tr', function () {
    var data = $childReferralTable.row( this ).data();  // (not used)
    window.location = "/referrals/"+$(this).attr('id');
  });

  $('.from_date').datepicker({ dateFormat: 'mm/dd/yy' });
  $('.to_date').datepicker({ dateFormat: 'mm/dd/yy' });

});
