// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function() {

  var userType = $('#referralList').data('usertype');

  /* fake enum used for switch statement -- values must match data-usertype
   * attributes in rendered tables. */
  var tableTypes = {
    VHA: 'vha',
    NON_VHA: 'non_vha'
  };

  /* get headers (title and data field binding) required by DataTables.
   * Header titles must match <thead> header names rendered in table.
   * Header data field names must match data from in Ajax JSON response. */
  function getHeaders() {
    var headers = [];
    switch (userType) {
      case tableTypes.VHA:
        headers.push({title: "Patient Name", data: "patient_name", orderable: true});
        headers.push({title: "Referral", data: "referral", orderable: true});
        headers.push({title: "SSN", data: "ssn", orderable: true});
        headers.push({title: "Date", data: "date", orderable: true});
        headers.push({title: "Status", data: "status", orderable: true});
        headers.push({title: "Coordinator", data: "coordinator", orderable: true});
        headers.push({title: "Provider", data: "provider", orderable: true});
        headers.push({title: "VISN:Facility", data: "visn_facility", orderable: true});
        break;

      case tableTypes.NON_VHA:
        headers.push({title: "Patient Name", data: "patient_name", orderable: true});
        headers.push({title: "Referral", data: "referral", orderable: true});
        headers.push({title: "Date", data: "date", orderable: true});
        headers.push({title: "Status", data: "status", orderable: true});
        headers.push({title: "Coordinator", data: "coordinator", orderable: true});
        headers.push({title: "Authorization#", data: "authorization_number", orderable: true});
        headers.push({title: "Consult#", data: "consultation_number", orderable: true});
        break;
    }
    return headers;
  }

  var $table = $('#referralList').DataTable({
    columns: getHeaders(),
    ajax: '/referrals/paged_list',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    bSort: true,
    bFilter: false,
    searching: false,
    pageLength: 10
  });

  $('#referralList tbody').on('click', 'tr', function () {
    var data = $table.row(this).data();
    if (!isNaN(parseInt(data.id))) {
      window.location = "referrals/" + parseInt(data.id);
    }
  });

  function showHideProviderFields(visible) {
      var $communityProviderSelect = $('select#referral_provider_id');

      if (visible) {
      $('.provider-datafields').show();
    }
    else {
      $('.provider-datafields').hide();
      $('.provider-datafields .provider-dropdown').val('');
      $('.provider-datafields span[data-fieldname]').text('');
    }
      if($communityProviderSelect.length){
          $communityProviderSelect.prop('required',visible);
      }
  }

  // show provider fields if "Ordering Provider performing services?" if false
  if ($('.show-provider-fields:checked').length > 0) {
    showHideProviderFields(true);
  }

  $('.show-provider-fields').click(function() {
    showHideProviderFields(true);
  });

  $('.hide-provider-fields').click(function() {
    showHideProviderFields(false);
  });

  $('.provider-datafields').on('change', '.provider-dropdown', function() {
    var providerId = parseInt($(this).val());
    if (!isNaN(providerId)) {
      $.getJSON('/providers/' + providerId).done(function(data) {
        // populating span fields with response data, using data-fieldname
        // to match span fields with data attributes
        $.each($('.provider-datafields').find('span[data-fieldname]'), function(indx, fieldEl) {
          var $fieldEl = $(fieldEl);
          var fieldname = $fieldEl.data('fieldname');
          $fieldEl.text(data[fieldname]);
        });
        $("#referral_provider_id").val(data['id']);
      }).fail(function(jqXHR) {
        $('#invalid-ssn').remove();
        $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid-ssn"> <div class="row"> <div class="small-12 columns">' +
          (jqXHR.responseJSON.error || 'Invalid NPI value.') + '</div> </div> </div>');
        window.scrollTo(0,0);
      });
    }
  });

  $('.referraltype_dropdown').on('change', function () {
    window.location = "/referrals/"+this.value;
  });

  function resetReferralForm(e){
    document.getElementById('referralFilterForm').reset();
    $("select#provider_id_select option").remove();
    $("select#facility_id_select option").remove();
    var row = "<option value=\"" + "" + "\">" + 'All' + "</option>";
    $(row).appendTo("select#provider_id_select");  $(row).appendTo("select#facility_id_select");
  }

  function submit_ajax_search() {
    var $form = $("form#referralFilterForm");
    $.ajax({
      type: "GET",
      url: $form.attr('action'),
      data: $form.serialize() // serializes the form's elements.
    })
    .done(submit_callback);
  }

  function submit_callback(data) {
    if (data.success) {
      $table.draw();
    }
    else {
      alert('Error settting Referral filtering preferences.  Consult the Help Desk for support.');
    }
  }

  $(document).on('click', 'button#resetReferralFilterButton', function(e) {
    resetReferralForm();
    $.get('/reset_referral_filter', submit_callback);
  });

  /* handle Filter button form action on top panel */
  $("form#referralFilterForm").submit(function(e) {
    e.preventDefault(); // avoid to execute the actual submit of the form.
    submit_ajax_search();
    return false;
  });

  $('a.referralStatusLink').click(function(e) {
    e.preventDefault(); // avoid to execute the actual submit of the form.
    resetReferralForm();
    var status = $(this).data('status-id');
    $("input[name='status[]']").prop('checked', false);
    $("input[name='status[]']").each( function () {
      if($(this).val() == status) {
        $(this).click();
      }
    });
    submit_ajax_search();
    return false;
  });

  $('a.referralSearchQuicklink').click(function(e) {
    e.preventDefault(); // avoid to execute the actual submit of the form.
    resetReferralForm();
    $.get($(this).attr('href')).done(submit_callback);
    return false;
  });

  $('input:radio[name="referral_complete_status"]').change( function(){
   if ($(this).is(':checked') && ($(this).val() == 'yes' || $(this).val() == 'no_completed'))
    {
      $('#referral_reason_id').prop("disabled", true);
    }
    else{
      $('#referral_reason_id').prop("disabled", false);
    }
  });

  autopopulate_referral();

});

function autopopulate_referral(){
  try {
    $('#from_date').val($('#from_date').data('source'));
    $('#to_date').val($('#to_date').data('source'));
    $('#first_name').val($('#first_name').data('source'));
    $('#last_name').val($('#last_name').data('source'));
    $('#ssn').val($('#ssn').data('source'));
    $('#coordinator_id').val($('#coordinator_id').data('source'));
    $('#care_category_id').val($('#care_category_id').data('source'));
    $('#consultation_number').val($('#consultation_number').data('source'));
    $('#authorization_number').val($('#authorization_number').data('source'));
    $('#visn_id_select').val($('#visn_id_select').data('source'));
    $('#provider_id_select').val($('#provider_id_select').data('source'));
    $('#referral_type_id').val($('#referral_type_id').data('source'));
    try {
      var selected_checkboxes = $("input[name='status[]']").data('source')
      var checkboxes = $("input[name='status[]']");
      checkboxes.each(function(_, element){
        if(selected_checkboxes.includes(element.value)) {
          element.checked = true;
        }
      });
     }catch(e){
      console.log("Error occurred while populating status values :" + e)
     }
  }
  catch(e){
    console.log("Error occurred while populating the session data in form : " + e)
  }
}
