// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function () {

    var oTable = $('#referralDocumentsTable').DataTable({
        bLengthChange: false,
        bFilter: false,
        bSort: true,
        aaSorting: [],
        aoColumnDefs: [{
            bSortable: false,
            aTargets: [5]
        }]
    });


    $('input[type=file].referralDocUploader').hide();


    $('button.referralDocUploader').click(function () {
        $('input.referralDocUploader').trigger('click');
        return false;
    });

    $('input.referralDocUploader').change(function (e) {
        var fileObj = e.target.files[0];
        $('input[type=text].docNameField').val(fileObj.name)
    });

    $('.viewmore_vha').click(function () {
        var $this = $(this);
        $this.toggleClass('viewmore_vha');
        if ($this.hasClass('viewmore_vha')) {
            $this.text('View More...');
            $('.hidecontent_vha').hide();
        } else {
            $this.text('View Less...');
            $('.hidecontent_vha').show();
        }
    });

    $('.viewmore_cp').click(function () {
        var $this = $(this);
        $this.toggleClass('viewmore_cp');
        if ($this.hasClass('viewmore_cp')) {
            $this.text('View More...');
            $('.hidecontent_cp').hide();
        } else {
            $this.text('View Less...');
            $('.hidecontent_cp').show();
        }
    });

    $('table#referralDocumentsTable.data-table.inline-editable').each(function () {
        $(this).inlineEditable({
            savePutURL: inlineEditSaveUrl

        });
    });

    // handle ajax event when user clicks on Reviewed checkbox, and replaces checkbox
    // with approver and datestamp if successful.
    var $documentsTable = $('#referralDocumentsTable');
    $documentsTable.on('change', 'input.approval-checkbox', function (e) {
        if (e.target && e.target.checked === true) {
            var $checkbox = $(e.target);
            var referralId = parseInt($checkbox.data('referral-id'));
            var docId = parseInt($checkbox.data('doc-id'));
            if (!isNaN(referralId) && !isNaN(docId)) {
                $.ajax({
                    type: "PUT",
                    url: "/referrals/" + referralId + "/referral_documents/" + docId + "/approve.json",
                    contentType: 'json'
                }).done(function (data) {
                    $checkbox.closest('td').html(data.reviewed_by).effect("highlight", {color: 'green'}, 1000);
                }).fail(function (jqXHR) {
                    $checkbox.prop('checked', false);
                    $checkbox.closest('td').effect("highlight", {color: 'red'}, 1000);
                });
            }
        }
    });


    function inlineEditSaveUrl(saveButton) {
        var referralId = $(saveButton).data("referral-id");
        var documentId = $(saveButton).data("referral-document-id");
        var url = "/referrals/" + referralId + "/referral_documents/" + documentId + ".json";
        return url;
    }

    $documentsTable.creatableDataTable('#referralDocumentsForm.creatable-target');


    $("form#referralDocumentsForm").submit(function (e) {
        if ($('#referral_document_referral_document_type_id').val() == "") {
            e.preventDefault();
            $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="invalid_referral_doc"> <div class="row"> <div class="small-12 columns"><span>Please select a Document Type.</div> </div> </div>');
            window.scrollTo(0, 0);
        }
    });
});