// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
$(document).ready(function () {

    // settting up datetimepicker to use Moment.js formatting.
    // The default date formatter does not respond well to daylight
    // savings time and will go back an hour after selecting a date.
    $.datetimepicker.setDateFormatter({
        parseDate: function (date, format) {
            var d = moment(date, format);
            return d.isValid() ? d.toDate() : false;
        },

        formatDate: function (date, format) {
            return moment(date).format(format);
        }
    });

    $('#appointment_datepicker').datetimepicker({
        step: 15,
        format: 'M/D/Y h:mm A',
        formatTime: 'h:mm A',
        formatDate: 'M/D/Y'
    })
        .datetimepicker('setDate', new Date());

    $('#referralAppointmentsTable .datetimepicker').each(function () {
        $(this).datetimepicker({
            step: 15,
            format: 'M/D/Y h:mm A',
            formatTime: 'h:mm A',
            formatDate: 'M/D/Y'
        }).datetimepicker('setDate', new Date($(this).val()));
    });

    function referralAppointmentsTableColumns() {
        var userType = $('#is_vha').val() == 'true';
        var columnsArr = [];
        switch (userType) {
            case true:
                columnsArr = [
                    {name: 'appointment_type', sortable: true},
                    {name: 'scheduled_by', sortable: true},
                    {name: 'date', sortable: true},
                    {name: 'created_in_cprs', sortable: false},
                    {name: 'links', sortable: false}
                ];
                break;
            case false:
                columnsArr = [
                    {name: 'appointment_type', sortable: true},
                    {name: 'scheduled_by', sortable: true},
                    {name: 'date', sortable: true},
                    {name: 'links', sortable: false}
                ];
                break;
        }
        return columnsArr;
    }

    var $referralAppointmentsTable = $('#referralAppointmentsTable');
    $referralAppointmentsTable.DataTable({
        bFilter: false,
        bLengthChange: false,
        bSort: true,
        aaSorting: [],
        columns: referralAppointmentsTableColumns(),
        "pageLength": 5
    });

    $referralAppointmentsTable.creatableDataTable("#referralAppointmentsForm.creatable-target");


    $('table#referralAppointmentsTable.data-table.inline-editable').each(function () {
        $(this).inlineEditable({
            savePutURL: inlineEditSaveUrl
        });
    });

    function inlineEditSaveUrl(saveButton) {
        var referralId = $(saveButton).data("referral-id");
        var appointmentId = $(saveButton).data("referral-appointment-id");
        var url = "/referrals/" + referralId + "/referral_appointments/" + appointmentId + ".json";
        return url;
    }

    // handle ajax event when user clicks on Reviewed checkbox, and replaces checkbox
    // with approver and datestamp if successful.
    $referralAppointmentsTable.on('click', 'input.cprs-approve-button', function (e) {
      e.preventDefault();
      var $button = $(e.target);
      var referralId = parseInt($button.data('referral-id'));
      var appointmentId = parseInt($button.data('appointment-id'));
      if (!isNaN(referralId) && !isNaN(appointmentId)) {
        $.ajax({
            type: "PUT",
            url: "/referrals/" + referralId + "/referral_appointments/" + appointmentId + "/add_to_cprs.json",
            contentType: 'json'
        })
        .done(function (data) {
            $button.closest('td').html(data.created_by).effect("highlight", {
                color: 'green'
            }, 1000);
        })
        .fail(function (jqXHR) {
            $button.prop('checked', false);
            $button.closest('td').effect("highlight", {
                color: 'red'
            }, 1000);
            $('#failed_to_save_in_vista').hide();
            $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="failed_to_save_in_vista"> <div class="row"> <div class="small-12 columns"><span>Error saving appointment to VISTA</div> </div> </div>');
            window.scrollTo(0, 0);
        });
      }
    });
});
