// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
$(document).ready(function() {

  function getQmAssignmentsHeaders() {
    return [
      {data: "name", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 0
      },
      {data: "row_label", targets: 1},
      {data: "qma_general_question", title: "General Question", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 2
      },
      {data: "qma_question_modifier", title: "Question Modifier", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 3
      },
      {data: "mod_type", title: "Modifier Type", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 4
      },
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 5, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\" ></a>";
        },
        targets: 6, searchable: false, orderable: false
      }
    ];
  }

  function constructUrl() {
    return window.location.pathname + "/paged_list";
  }


  $("#qm-assignment-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getQmAssignmentsHeaders(),
    ajax: constructUrl(),
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    serverSide: true,
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "qma_general_question", "targets": [2]},
        {"className": "qma_question_modifier", "targets": [3]},
        {"className": "mod_type", "targets": [4]},
        {"className": "edit td-data-center", "targets": [5]},
        {"className": "destroy td-data-center", "targets": [6]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  $("[id$=-questions]").sortable({
    axis: 'y',
    update: function(event, ui) {
      $.ajax({
        type: "POST",
        url: $(this).data('update-url'),
        data:  $(this).sortable('serialize')
      });
    }
  });
});

