// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function() {

  function getGeneralQuestionsHeaders() {
    return [
      {data: "name", render: function(data, type, row) {
          if (data.length > 100)
            return (data.slice(0,100) + "\n" + data.slice(100, data.length));
          return data;
        },
        targets: 0
      },
      {data: "row_label", targets: 1},
      {data: "edit", render: function(data, type, row) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 2, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data, type, row) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\" ></a>";
        },
        targets: 3, searchable: false, orderable: false
      }
    ];
  }


  $("#general-questions-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getGeneralQuestionsHeaders(),
    ajax: '/general_questions/paged_list',
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    serverSide: true,
    pageLength: 25,
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "edit td-data-center", "targets": [2]},
        {"className": "destroy td-data-center", "targets": [3]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  //General Question Edit page: Search/mulitple select for choosing diagnosis modifiers
  $("form.edit_general_question #general_question_question_modifier_ids").chosen({
    placeholder_text_multiple: "Existing Question Modifiers",
    search_contains: true
  })

  $("form.general_questions #general_question_dbq_information_ids").chosen({
    placeholder_text_multiple: "Existing DBQ Informations",
    search_contains: true
  })
})