// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.
function defineEs6EndsWith() {
  if (!String.prototype.endsWith) {
    String.prototype.endsWith = function(searchString, position) {
    var subjectString = this.toString();
    if (typeof position !== 'number' || !isFinite(position) || Math.floor(position) !== position || position > subjectString.length) {
      position = subjectString.length;
    }
    position -= searchString.length;
    var lastIndex = subjectString.indexOf(searchString, position);
    return lastIndex !== -1 && lastIndex === position;
    };
  }
}

function defineEs6StartsWith() {
  if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(searchString, position) {
      position = position || 0;
      return this.indexOf(searchString, position) === position;
    };
  }
}


function Bump_Dependent_Elements_Based_On(The_Controlling_Element)
{
//  alert("in Bump_Dependent_Elements_Based_On");
}

function Set_Dependent_Visibility_Based_On(The_Controlling_Element)
{
  defineEs6EndsWith();
//  alert("in set_dependent_visibility_based_on");
//  alert(The_Controlling_Element.id)
  var The_Controlled_Elements_Should_Be_Made_Visible_On_Yes = Visibility_Is_Specified_By( The_Controlling_Element );
  var The_Controlled_Elements_String = The_Controlling_Element.getAttribute('visibility_dependents');

//  alert(The_Controlled_Elements);
  var The_Array_Of_Controlled_Elements = [];
  if(The_Controlled_Elements_String.length > 0)
  {
    var The_Array_Of_Controlled_Elements = The_Controlled_Elements_String.split(',');
  }
  // Element is a not applicable or other type
  var na_other_element = The_Controlling_Element.id.endsWith('-other') || The_Controlling_Element.id.endsWith('-na')
  for(var index=0; index<The_Array_Of_Controlled_Elements.length; index++)
  {
//    alert( The_Array_Of_Controlled_Elements[index]);
    Set_The_Visibility_Of_A_Controlled_Element( The_Array_Of_Controlled_Elements[index],The_Controlled_Elements_Should_Be_Made_Visible_On_Yes, na_other_element);
  }
}


function Set_The_Visibility_Of_A_Controlled_Element(The_Element_ID, The_Element_Should_Be_Visible_On_Yes, Na_Other)
{
  defineEs6StartsWith();
  var The_Element = document.getElementById( The_Element_ID );
// alert(The_Element_ID);
  // NA or other has been selected
  if (Na_Other)
  {
    // Show the NA_Other sub component.
    if (The_Element_ID.startsWith('na-') || The_Element_ID.startsWith('na_other')){      
      The_Element.classList.remove("hidden");
    }
    // Hide the Yes and No sub elements.
    else{
      The_Element.classList.add("hidden");      
    }
  }
  else if( The_Element_Should_Be_Visible_On_Yes )
  {
    // For a yes selection, the na_other textarea get hidden.
    if (The_Element_ID.startsWith('na-') || The_Element_ID.startsWith('na_other')){      
      The_Element.classList.add("hidden");
    }    
    // Hide elements that should only be visible on a No.
    else if (The_Element_ID.indexOf("negative") >= 0){
      The_Element.classList.add("hidden");
    }
    // Show elements that should be visible on a Yes.    
    else{
      The_Element.classList.remove("hidden");
    }
  }
  // Element is visible on a No.
  else
  {
    // For this No selection, the na_other textarea get hidden.    
    if (The_Element_ID.startsWith('na_other')){      
      The_Element.classList.add("hidden");
    }      
    // Show elements that should be visible on a No.
    else if (The_Element_ID.indexOf("negative") >= 0){
      The_Element.classList.remove("hidden");
    }
    // Hide elements that should be visible on a Yes.
    else{
      The_Element.classList.add("hidden");
    }
  }
}

function Visibility_Is_Specified_By( The_Element_To_Check )
{
  if( The_Element_To_Check instanceof HTMLInputElement )
  {
    var The_Result = false;

//    alert( 'Input Element' );

    switch( The_Element_To_Check.type )
    {
      case 'checkbox':
 //       alert( 'checkbox' );
        The_Result = The_Element_To_Check.checked;
      break;

      case 'radio':
        defineEs6EndsWith();

        The_Result = (The_Element_To_Check.checked && The_Element_To_Check.id.endsWith('-yes'));
      break;

      default:
        alert( 'DEFAULT:' + The_Element_To_Check.type );
    }
  }
  return The_Result;
}
