$(document).ready(function() {

  function getDmAssignmentsHeaders() {
    return [
      {data: "name", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 0
      },
      {data: "row_label", targets: 1},
      {data: "dma_diagnosis", title: "Diagnosis", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 2
      },
      {data: "dma_diagnosis_modifier", title: "Diagnosis Modifier", render: function(data) {
          if (data.length > 50)
            return (data.slice(0,50) + "\n" + data.slice(50, data.length));
          return data;
        },
        targets: 3
      },
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 4, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 5, searchable: false, orderable: false
      }
    ];
  }

  function constructUrl() {
    return window.location.pathname + "/paged_list";
  }


  $("#dm-assignment-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getDmAssignmentsHeaders(),
    ajax: constructUrl(),
    processing: true,
    serverSide: true,
    pageLength: 25,
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "dma_diagnosis", "targets": [2]},
        {"className": "dma_diagnosis_modifier", "targets": [3]},
        {"className": "edit td-data-center", "targets": [4]},
        {"className": "destroy td-data-center", "targets": [5]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });
})
