// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

$(document).ready(function() {

  function getDiagnosesHeaders() {
    return [
      {data: "name", render: function(data, type, row) {
          if (data.length > 100)
            return (data.slice(0,100) + "\n" + data.slice(100, data.length));
          return data;
        },
        targets: 0
      },
      {data: "row_label", targets: 1},
      {data: "code", targets: 2},
      {data: "edit", render: function(data, type, row) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 3, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data, type, row) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\" ></a>";
        },
        targets: 4, searchable: false, orderable: false
      }
    ];
  }


  $("#diagnoses-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getDiagnosesHeaders(),
    ajax: '/diagnoses/paged_list',
    processing: true,
    serverSide: true,
    pageLength: 25,
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "row_label", "targets": [1]},
        {"className": "code", "targets": [2]},
        {"className": "edit td-data-center", "targets": [3]},
        {"className": "destroy td-data-center", "targets": [4]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  //Diagnosis Edit page: Search/mulitple select for choosing diagnosis modifiers
  $("form.edit_diagnosis #diagnosis_diagnosis_modifier_ids").chosen({
    placeholder_text_multiple: "Existing Diagnosis Modifiers",
    search_contains: true
  })

  $("form.diagnosis #diagnosis_dbq_information_ids").chosen({
    placeholder_text_multiple: "Existing DBQ Informations",
    search_contains: true
  })
})
