$(document).ready(function() {

 	function getDbqHeaders() {
    return [
      {data: "identifier", targets: 1},
      {data: "title", targets: 0},
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 2, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 3, searchable: false, orderable: false
      }
    ];
  };

  function getDbqReturnData() {
    var $inputTag = $("#dbq-informations-index-data");
    if ($inputTag.length > 0)
      return JSON.parse($inputTag.val()).data;
    else
      return [];
  };

	$("#dbq-infomations-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    data: getDbqReturnData(),
    columns: getDbqHeaders(),
    pageLength: 25,
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    columnDefs: [
        {"className": "title", "targets": [0]},
        {"className": "identifier", "targets": [1]},
        {"className": "edit td-data-center", "targets": [2]},
        {"className": "destroy td-data-center", "targets": [3]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  $("[id$=-systems]").sortable({
		axis: 'y',
		update: function(event, ui) {
			$.ajax({
				type: "POST",
				url: $(this).data('update-url'),
				data:  $(this).sortable('serialize')
			});
		}
	});

  $("form.edit_dbq_information #dbq_information_contention_ids").chosen({
	  placeholder_text_multiple: "Associate Contentions",
	  search_contains: true
	})

  $("form.symptoms #dbq_information_symptom_ids").chosen({
    placeholder_text_multiple: "Associate Symptoms",
    search_contains: true
  })

  $("form.diagnoses #dbq_information_diagnosis_ids").chosen({
    placeholder_text_multiple: "Associate Diagnoses",
    search_contains: true
  })

  $("form.general-questions #dbq_information_general_question_ids").chosen({
    placeholder_text_multiple: "Associate General Questions",
    search_contains: true
  })

});
