$(document).ready(function(){

 	function getBoilerPlateHeaders() {
    return [
      {data: "name", targets: 0},
      {data: "content", targets: 1},
      {data: "edit", render: function(data) {
          return "<a href=\"" + data +"\" class='fa fa-pencil-square-o fa-lg' title='edit'></a>";
        },
        targets: 2, searchable: false, orderable: false
      },
      {data: "destroy", render: function(data) {
          return "<a data-method=\"delete\" data-confirm=\"Are you sure?\" class='fa fa-trash-o fa-lg' title='delete' href=\"" + data +"\"></a>";
        },
        targets: 3, searchable: false, orderable: false
      }
    ];
  };

  function getBoilerPlateReturnData() {
    var $inputTag = $("#boilerplate-messages-index-data");
    if ($inputTag.length > 0)
      return JSON.parse($inputTag.val()).data;
    else
      return [];
  };

	$("#boilerplate-messages-index-table").DataTable({
    language: {
      lengthMenu: "Display _MENU_ Records",
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    data: getBoilerPlateReturnData(),
    columns: getBoilerPlateHeaders(),
    pageLength: 25,
    processing: true,
    language: {
      processing: "<div><i class='fa fa-cog fa-2x fa-spin'></i></div>"
    },
    columnDefs: [
        {"className": "name", "targets": [0]},
        {"className": "content", "targets": [1]},
        {"className": "edit td-data-center", "targets": [2]},
        {"className": "destroy td-data-center", "targets": [3]}
      ],
    createdRow: function ( row, data, dataIndex ) {
      $(row).children('td').each (function(){
        var className = $(this).attr('class').replace('td-data-center','').trim();
        $(this).attr('headers', className);
      });
    }
  });

  $("[id$=-systems]").sortable({
		axis: 'y',
		update: function(event, ui) {
			$.ajax({
				type: "POST",
				url: $(this).data('update-url'),
				data:  $(this).sortable('serialize')
			});
		}
	});

  $("form.edit_boilerplate_message #boilerplate_message_dbq_information_ids").chosen({
	  placeholder_text_multiple: "Associate DBQ Informations",
	  search_contains: true
	})

});
